/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin;

import com.atlassian.jira.functest.framework.FuncTestRuleChain;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.plugins.Plugins;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

@WebTest(value={Category.FUNC_TEST})
public class TestBundledPlugins {
    @Rule
    public RuleChain funcTestRuleChain = FuncTestRuleChain.forTest(this);
    public static final Map<String, String> PLUGINS = ImmutableMap.builder().put((Object)"com.atlassian.activeobjects.activeobjects-plugin", (Object)"Active Objects").put((Object)"com.atlassian.gadgets.dashboard", (Object)"Gadgets Dashboard").put((Object)"com.atlassian.gadgets.directory", (Object)"Gadgets Directory").put((Object)"com.atlassian.gadgets.embedded", (Object)"Gadgets Embedded").put((Object)"com.atlassian.gadgets.oauth.serviceprovider", (Object)"Gadgets Service Provider").put((Object)"com.atlassian.gadgets.opensocial", (Object)"Gadgets Opensocial").put((Object)"com.atlassian.gadgets.publisher", (Object)"Gadgets Publisher").put((Object)"com.atlassian.administration.atlassian-admin-quicksearch-jira", (Object)"Admin Quicksearch").put((Object)"com.atlassian.jira.extra.jira-ical-feed", (Object)"iCalendar").put((Object)"com.atlassian.labs.atlassian-bot-killer", (Object)"Bot Killer").build();
    @Inject
    private Plugins plugins;

    @Test
    @LoginAs(user="admin")
    public void testIfPluginsAreInstalledAndEnabled() throws Exception {
        List notInstalledPlugins = PLUGINS.keySet().stream().filter(key -> !this.plugins.isPluginInstalled((String)key)).map(PLUGINS::get).collect(Collectors.toList());
        Assert.assertThat((String)"The following plugins are not installed:", notInstalledPlugins, (Matcher)Matchers.emptyIterable());
        List notEnabledPlugins = PLUGINS.keySet().stream().filter(key -> !this.plugins.isPluginEnabled((String)key)).map(PLUGINS::get).collect(Collectors.toList());
        Assert.assertThat((String)"The following plugins are not enabled:", notEnabledPlugins, (Matcher)Matchers.emptyIterable());
    }
}

