/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.SessionFactory;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.COMPONENTS_AND_VERSIONS, Category.PROJECTS})
@LoginAs(user="admin")
public class TestComponentValidation
extends BaseJiraFuncTest {
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private SessionFactory sessionFactory;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestBrowseProjectRoadmapAndChangeLogTab.xml");
        this.backdoor.usersAndGroups().addUser("dev", "dev", "Developer", "dev@example.com");
        this.backdoor.usersAndGroups().addUserToGroup("dev", "jira-developers");
    }

    @Test
    public void testComponentValidationSwitchingProjectsUnderneath() {
        this.navigation.issue().viewIssue("LOTS-1");
        this.tester.clickLink("edit-issue");
        this.sessionFactory.begin().withSession(() -> {
            this.navigation.login("admin");
            this.navigation.issue().viewIssue("LOTS-1");
            this.tester.clickLink("move-issue");
            this.tester.setFormElement("pid", "10051");
            this.tester.submit("Next >>");
            this.tester.submit("Next >>");
            this.tester.submit("Move");
            this.assertions.assertNodeExists("//a[@title='Component 1 ']");
        });
        this.tester.submit("Update");
        this.assertions.assertNodeHasText("//*[@class='error']", "Components Component 1(10030), Component 3(10031) are not valid for project 'All Released'.");
        this.assertions.assertNodeHasText("//*[@id='key-val']", "RELEASED-1");
    }

    @Test
    public void testComponentValidationNonExistentComponent() {
        this.navigation.login("dev");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/EditIssue.jspa?id=10000&summary=LOTS-1&components=99&assignee=admin&reporter=admin&issuetype=1"));
        this.assertions.assertNodeHasText("//*[@class='error']", "Component with id '99' does not exist.");
    }
}

