/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
@LoginAs(user="admin")
public class TestEditProject
extends BaseJiraFuncTest {
    public static final String EDIT_PROJECT_PAGE_URL = "/secure/project/EditProject!default.jspa?pid=";
    public static final String PROJ_NAME = "Canine";
    public static final Object NONE_PROJECT_CATEGORY = null;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestEditProject.xml");
    }

    @Test
    public void testProjectDoesNotExistAdmin() throws Exception {
        this.tester.gotoPage("/secure/project/EditProject!default.jspa?pid=999999");
        this.tester.assertTextPresent("There is not a project with the specified id. Perhaps it was deleted.");
    }

    @Test
    public void testProjectDoesNotExistNonAdmin() throws Exception {
        this.navigation.logout();
        this.tester.gotoPage("secure/project/EditProject!default.jspa?pid=999999");
        this.tester.assertTextPresent("You must log in to access this page.");
        this.navigation.login("gandhi");
        this.tester.gotoPage("secure/project/EditProject!default.jspa?pid=999999");
        this.tester.assertTextPresent("Access Denied");
        this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.tester.assertTextNotPresent("You cannot view this URL as a guest.");
    }

    @Test
    public void testEditProjectSuccess() {
        this.backdoor.project().addProjectCategory("Test Project Category", "Test description");
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project dog = pc.get("DOG");
        Assert.assertEquals((Object)"DOG", (Object)dog.key);
        Assert.assertEquals((Object)PROJ_NAME, (Object)dog.name);
        Assert.assertEquals((Object)"", (Object)dog.description);
        Assert.assertEquals(null, (Object)dog.url);
        Assert.assertEquals((Object)"murray", (Object)dog.lead.name);
        Assert.assertEquals((Object)NONE_PROJECT_CATEGORY, (Object)dog.projectCategory);
        Assert.assertEquals((Object)Project.AssigneeType.PROJECT_LEAD, (Object)dog.assigneeType);
        this.tester.gotoPage(EDIT_PROJECT_PAGE_URL + dog.id);
        this.tester.assertTextPresent(PROJ_NAME);
        this.tester.setFormElement("name", "Dogs");
        this.tester.setFormElement("url", "http://www.dogs.com");
        this.tester.setFormElement("description", "This is the dog project.");
        this.tester.selectOption("projectCategoryId", "Test Project Category");
        this.tester.submit();
        dog = pc.get("DOG");
        Assert.assertThat((Object)dog.name, (Matcher)CoreMatchers.equalTo((Object)"Dogs"));
        Project newDog = pc.get("DOG");
        Assert.assertEquals((Object)"DOG", (Object)newDog.key);
        Assert.assertEquals((Object)"Dogs", (Object)newDog.name);
        Assert.assertEquals((Object)"This is the dog project.", (Object)newDog.description);
        Assert.assertEquals((Object)"http://www.dogs.com", (Object)newDog.url);
        Assert.assertEquals((Object)"murray", (Object)newDog.lead.name);
        Assert.assertEquals((Object)"Test Project Category", (Object)dog.projectCategory.name);
        Assert.assertEquals((Object)Project.AssigneeType.PROJECT_LEAD, (Object)newDog.assigneeType);
    }

    @Test
    public void testEditProjectNameExists() {
        Long projectId = this.backdoor.project().getProjectId("DOG");
        this.tester.gotoPage(EDIT_PROJECT_PAGE_URL + projectId);
        this.tester.assertTextPresent(PROJ_NAME);
        this.tester.setFormElement("name", "Bovine");
        this.tester.submit();
        this.tester.assertTextPresent("A project with that name already exists.");
    }

    @Test
    public void testEditProjectValidation() {
        this.backdoor.project().addProjectCategory("Test Project Category", "Test description");
        Long projectId = this.backdoor.project().getProjectId("DOG");
        this.tester.gotoPage(EDIT_PROJECT_PAGE_URL + projectId);
        this.backdoor.project().deleteProjectCategory("10000");
        this.tester.assertTextPresent(PROJ_NAME);
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("url", "badURL");
        this.tester.setFormElement("projectCategoryId", "10000");
        this.tester.submit();
        this.tester.assertTextPresent("You must specify a valid project name.");
        this.tester.assertTextPresent("The URL specified is not valid - it must start with http://");
        this.tester.assertTextPresent("That project category is no longer valid, it may have been deleted. Please pick another project category.");
    }

    @Test
    public void testEditProjectNoAccess() {
        this.navigation.logout();
        this.navigation.login("cow", "cow");
        this.tester.gotoPage("secure/admin/EditProject.jspa?pid=10020&name=newproject&lead=admin&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent("Welcome to Dev JIRA");
        this.tester.assertTextNotPresent(PROJ_NAME);
        this.tester.assertTextNotPresent("Use this page to update your project details.");
    }

    @Test
    public void testEditProjectDoesntExist() {
        this.tester.gotoPage("secure/admin/EditProject.jspa?pid=10025&name=newproject&lead=admin&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent("There is not a project with the specified id. Perhaps it was deleted.");
    }

    @Test
    public void testEditProjectChangeNothing() {
        Long projectId = this.backdoor.project().getProjectId("DOG");
        this.tester.gotoPage(EDIT_PROJECT_PAGE_URL + projectId);
        this.tester.assertTextPresent(PROJ_NAME);
        this.tester.setFormElement("name", PROJ_NAME);
        this.tester.setFormElement("url", "");
        this.tester.setFormElement("description", "");
        this.tester.submit();
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project dog = pc.get("DOG");
        Assert.assertEquals((Object)"DOG", (Object)dog.key);
        Assert.assertEquals((Object)PROJ_NAME, (Object)dog.name);
        Assert.assertEquals((Object)"", (Object)dog.description);
        Assert.assertEquals(null, (Object)dog.url);
        Assert.assertEquals((Object)"murray", (Object)dog.lead.name);
        Assert.assertEquals(null, (Object)dog.projectCategory);
        Assert.assertEquals((Object)Project.AssigneeType.PROJECT_LEAD, (Object)dog.assigneeType);
    }

    @Test
    public void testEditWithFieldsExceedingLimits() throws Exception {
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project dog = pc.get("DOG");
        Assert.assertEquals((Object)"DOG", (Object)dog.key);
        Assert.assertEquals((Object)PROJ_NAME, (Object)dog.name);
        Assert.assertEquals((Object)"", (Object)dog.description);
        Assert.assertEquals(null, (Object)dog.url);
        Assert.assertEquals((Object)"murray", (Object)dog.lead.name);
        Assert.assertEquals((Object)NONE_PROJECT_CATEGORY, (Object)dog.projectCategory);
        Assert.assertEquals((Object)Project.AssigneeType.PROJECT_LEAD, (Object)dog.assigneeType);
        Long projectId = this.backdoor.project().getProjectId("DOG");
        this.tester.gotoPage(EDIT_PROJECT_PAGE_URL + projectId);
        this.tester.assertTextPresent(PROJ_NAME);
        this.tester.setFormElement("name", StringUtils.repeat((String)"N", (int)81));
        this.tester.setFormElement("url", StringUtils.repeat((String)"U", (int)256));
        this.tester.submit();
        this.tester.assertTextPresent("The project name must not exceed 80 characters in length");
        this.tester.assertTextPresent("The URL must not exceed 255 characters in length");
    }

    @Test
    public void testEditProjectWithoutBrowseProjectPermission() throws Exception {
        Long projectId = this.backdoor.project().getProjectId("VG");
        this.backdoor.project().addProjectCategory("Test Project Category", "Test description");
        this.tester.gotoPage(EDIT_PROJECT_PAGE_URL + projectId);
        this.tester.setFormElement("name", "Vegans");
        this.tester.selectOption("projectCategoryId", "Test Project Category");
        this.tester.submit();
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project dog = pc.get("VG");
        Assert.assertEquals((Object)"VG", (Object)dog.key);
        Assert.assertEquals((Object)"Vegans", (Object)dog.name);
        Assert.assertEquals((Object)"Test Project Category", (Object)dog.projectCategory.name);
    }

    @Test
    public void testProjectCategoriesShowNoneWhenNoCategoriesExist() {
        Long projectId = this.backdoor.project().getProjectId("VG");
        this.tester.gotoPage(EDIT_PROJECT_PAGE_URL + projectId);
        this.tester.assertOptionsEqual("projectCategoryId", new String[]{"None"});
    }

    @Test
    public void testProjectCategoriesShowCategoriesWhenTheyExist() {
        Long projectId = this.backdoor.project().getProjectId("VG");
        this.backdoor.project().addProjectCategory("A", "Test description A");
        this.backdoor.project().addProjectCategory("B", "Test description B");
        this.backdoor.project().addProjectCategory("C", "Test description C");
        this.backdoor.project().addProjectCategory("D", "Test description D");
        String[] projectCategoriesOptions = new String[]{"None", "A", "B", "C", "D"};
        this.tester.gotoPage(EDIT_PROJECT_PAGE_URL + projectId);
        this.tester.assertOptionsEqual("projectCategoryId", projectCategoriesOptions);
    }
}

