/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
@LoginAs(user="admin")
public class TestEditProjectPCounter
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testEditProjectPCounter() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.project().addProject("Bovine", "COW", "admin");
        this.administration.project().addProject("Canine", "DOG", "admin");
        this.navigation.issue().createIssue("Bovine", "Bug", "Three legged dog");
        this.navigation.issue().createIssue("Bovine", "Bug", "Where's the cheese?");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("Canine");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
        this.textAssertions.assertTextPresent("DOG-1");
        this.navigation.gotoPage("browse/COW-1");
        this.textAssertions.assertTextPresent("DOG-1");
        this.textAssertions.assertTextPresent("Three legged dog");
        Long projectId = this.backdoor.project().getProjectId("COW");
        this.tester.gotoPage("/secure/project/EditProject!default.jspa?pid=" + projectId);
        this.tester.setFormElement("description", "Some description");
        this.tester.submit();
        this.navigation.issue().createIssue("Bovine", "Bug", "I like cheese");
        this.textAssertions.assertTextNotPresent("COW-1");
        this.textAssertions.assertTextPresent("COW-3");
        this.textAssertions.assertTextPresent("I like cheese");
        this.navigation.gotoPage("browse/COW-1");
        this.textAssertions.assertTextPresent("DOG-1");
        this.textAssertions.assertTextPresent("Three legged dog");
    }
}

