/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestNotificationOptions
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testComponentLeadIsAnOptionForIssueCreatedNotifications() throws Exception {
        this.administration.restoreBlankInstance();
        this.goToDefaultNotificationScheme();
        this.goToAddIssueCreatedNotificationPage();
        this.textAssertions.assertTextPresent(this.locator.page(), "Component Lead");
    }

    @Test
    public void testProjectRoleIsAnOptionForIssueCreatedNotifications() {
        this.administration.restoreData("TestSchemesProjectRoles.xml");
        this.goToDefaultNotificationScheme();
        this.goToAddIssueCreatedNotificationPage();
        this.textAssertions.assertTextPresent(this.locator.page(), "Choose a project role");
        this.tester.checkCheckbox("type", "Project_Role");
        this.tester.selectOption("Project_Role", "test role");
        this.tester.submit();
        this.textAssertions.assertTextPresent(this.locator.page(), "(test role)");
    }

    private void goToDefaultNotificationScheme() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Notifications");
    }

    private void goToAddIssueCreatedNotificationPage() {
        this.tester.clickLink("add_1");
    }
}

