/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.SessionFactory;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.COMPONENTS_AND_VERSIONS, Category.PROJECTS})
@LoginAs(user="admin")
public class TestVersionValidation
extends BaseJiraFuncTest {
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private SessionFactory sessionFactory;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestBrowseProjectRoadmapAndChangeLogTab.xml");
    }

    @Test
    public void testVersionValidationSwitchingProjectsUnderneath() {
        this.navigation.issue().viewIssue("LOTS-1");
        this.tester.clickLink("edit-issue");
        this.sessionFactory.begin().withSession(() -> {
            this.navigation.login("admin");
            this.navigation.issue().viewIssue("LOTS-1");
            this.tester.clickLink("move-issue");
            this.tester.setFormElement("pid", "10051");
            this.tester.submit("Next >>");
            this.tester.submit("Next >>");
            this.tester.submit("Move");
            this.assertions.assertNodeExists("//a[@title='Version 1 ']");
        });
        this.tester.submit("Update");
        this.assertions.assertNodeHasText("//*[@class='error']", "Versions Version 1(10040), Version 2(10041), Version A(10042), Version <b>B</b>(10043), Version 3(10044), Version Version(10045), Version 6(10046), Version 8(10047), Version Nick(10048), This is getting silly(10060), V2(10059), Lets throw in a Date(10058), Still going(10057), Version Justus(10054), Version Brenden(10053) are not valid for project 'All Released'.");
        this.assertions.assertNodeHasText("//*[@id='key-val']", "RELEASED-1");
    }

    @Test
    public void testVersionValidationNonExistentVersion() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/EditIssue.jspa?id=10000&summary=LOTS-1&fixVersions=999&assignee=admin&reporter=admin&issuetype=1"));
        this.assertions.assertNodeHasText("//*[@class='error']", "Version with id '999' does not exist.");
    }
}

