/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS, Category.ROLES})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestViewProjectsXSS
extends BaseJiraFuncTest {
    private static final String CATEGORY_NAME = "\"><div id='xss-test'>XSS injected</div>";
    private static final String CATEGORY_DESCRIPTION = "XSS Category Description";
    private static final String projectKey = "XSS";
    private static final String xssEscaped = "&quot;&gt;&lt;div id=&#39;xss-test&#39;&gt;XSS injected&lt;/div&gt;";
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @After
    public void tearDownTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testViewProjectsXSStroughTranslatedCategoryName() {
        long projectId = this.backdoor.project().addProject("Project with category", projectKey, "admin");
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.navigation.gotoPage("/secure/project/SelectProjectCategory!default.jspa?pid=" + projectId);
        this.tester.selectOption("projectCategoryId", CATEGORY_NAME);
        this.tester.submit("Select");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.assertElementNotPresent("xss-test");
        this.tester.assertTextPresent(xssEscaped);
    }

    private void createProjectCategory(String categoryName, String categoryDescription) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CATEGORIES);
        this.tester.setFormElement("name", categoryName);
        this.tester.setFormElement("description", categoryDescription);
        this.tester.submit("Add");
    }
}

