/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.BaseTestWorkflowSchemeResource;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.EditDraftWorkflowSchemeResource;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleIssueType;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleWorkflow;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleWorkflowScheme;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.WorkflowSchemeResource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreOnce(value="TestProjectWorkflowSchemeResource.xml")
@LoginAs(user="admin")
public class TestProjectDraftWorkflowSchemeResource
extends BaseTestWorkflowSchemeResource {
    @Test
    public void testEditNoWorkflowName() {
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.editResponse(HSP.getKey(), "", "1");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testEditNoIssueTypes() {
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.editResponse(HSP.getKey(), "monkey Workflow", new String[0]);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testEditNoProject() {
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.editResponse("No such project", "monkey Workflow", "1");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testEditNoPermissionAnonymous() {
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        ParsedResponse response = ((EditDraftWorkflowSchemeResource)client.anonymous()).editResponse(HSP.getKey(), "monkey Workflow", "1");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testEditNoAdminPermission() {
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        ParsedResponse response = ((EditDraftWorkflowSchemeResource)client.loginAs("proj")).editResponse(HSP.getKey(), "monkey Workflow", "1");
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("You do not have permission to administer the workflow scheme."));
    }

    @Test
    public void testEditNoWorkflow() {
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.editResponse(HSP.getKey(), "No such WF", "1");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testEditNoIssueType() {
        String projectKey = "ENIT";
        this.backdoor.project().addProject("testEditNoIssueType", "ENIT", "admin");
        WorkflowSchemeResource workflowSchemeResource = new WorkflowSchemeResource(this.environmentData);
        workflowSchemeResource.createDraftWorkflowScheme("ENIT");
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.editResponse("ENIT", "monkey Workflow", "No such issue type");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("The specified issue type does not exist in the project."));
        response = client.editResponse("ENIT", "monkey Workflow", "No such issue type", "1");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("The specified issue type does not exist in the project."));
    }

    @Test
    public void testEditNoDraftScheme() {
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.editResponse(HSP.getKey(), "monkey Workflow", "1");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("The workflow scheme does not have a draft."));
    }

    @Test
    public void testEditMakeNewDefault() {
        SimpleIssueType bug = this.bug();
        bug.setDefaultIssueType(true);
        SimpleIssueType improvement = this.improvement();
        SimpleIssueType monkey = this.monkey();
        SimpleIssueType newFeature = this.newFeature();
        SimpleIssueType task = this.task();
        SimpleIssueType ignored = this.ignored();
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme pwdws = client.edit(PROJECT_WITH_DRAFT_WORKFLOW_SCHEME.getKey(), "monkey Workflow", bug.getId(), newFeature.getId(), task.getId(), improvement.getId(), ignored.getId(), monkey.getId());
        List<SimpleIssueType> issueTypes = Arrays.asList(bug, ignored, improvement, monkey, newFeature, task);
        Assert.assertEquals(issueTypes, pwdws.getIssueTypes());
        Assert.assertEquals((Object)"monkey workflow scheme 4", (Object)pwdws.getName());
        Assert.assertNull((Object)pwdws.getDescription());
        Assert.assertTrue((boolean)pwdws.isAdmin());
        Assert.assertFalse((boolean)pwdws.isDefaultScheme());
        Assert.assertEquals(Arrays.asList(PROJECT_WITH_DRAFT_WORKFLOW_SCHEME), pwdws.getShared().getSharedWithProjects());
        Assert.assertTrue((boolean)pwdws.isDraftScheme());
        Assert.assertEquals((Object)ADMIN_USER, (Object)pwdws.getLastModifiedUser());
        Assert.assertEquals((Object)"admin", (Object)pwdws.getCurrentUser());
        SimpleWorkflow monkeyWorkflow = new SimpleWorkflow("monkey Workflow", null, true, false, Arrays.asList(bug.getId(), ignored.getId(), improvement.getId(), monkey.getId(), newFeature.getId(), task.getId()));
        Assert.assertEquals(Arrays.asList(monkeyWorkflow), pwdws.getMappings());
    }

    @Test
    public void testEditDraftWithMultipleShares() {
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.editResponse(PROJECT_WITH_SHARED_DRAFT_SCHEME.getKey(), "jira", "1");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("You can only edit a workflow scheme if it is associated uniquely to your project."));
    }

    @Test
    public void testRemoveWorkflowFromDraftScheme() {
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        SimpleWorkflowScheme scheme = client.remove(PROJECT_WITH_WORKFLOW_TO_DELETE.getKey(), "jira");
        SimpleIssueType bug = this.bug();
        SimpleIssueType improvement = this.improvement();
        SimpleIssueType monkey = this.monkey();
        SimpleIssueType newFeature = this.newFeature();
        SimpleIssueType task = this.task();
        SimpleIssueType ignored = this.ignored();
        SimpleWorkflow workflow = new SimpleWorkflow("monkey Workflow", null, true, false, Arrays.asList(bug.getId(), ignored.getId(), improvement.getId(), monkey.getId(), newFeature.getId(), task.getId()));
        Assert.assertEquals(Collections.singletonList(workflow), scheme.getMappings());
    }

    @Test
    public void testRemoveWorkflowFromDraftSchemeBad() {
        EditDraftWorkflowSchemeResource client = new EditDraftWorkflowSchemeResource(this.environmentData);
        ParsedResponse response = client.removeResponse(PROJECT_WITH_WORKFLOW_TO_DELETE.getKey(), "");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = ((EditDraftWorkflowSchemeResource)client.anonymous()).removeResponse(PROJECT_WITH_WORKFLOW_TO_DELETE.getKey(), "skdaskdla");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((EditDraftWorkflowSchemeResource)client.loginAs("fred")).removeResponse(PROJECT_WITH_WORKFLOW_TO_DELETE.getKey(), "skdaskdla");
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        response = ((EditDraftWorkflowSchemeResource)client.loginAs("admin")).removeResponse("Key Which Does not Exist", "sjdskjasd");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = client.removeResponse(PROJECT_WITH_WORKFLOW_TO_DELETE.getKey(), "I also Don't Exist");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = client.removeResponse(MKY.getKey(), "jira");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = client.removeResponse(PROJECT_WITH_SHARED_DRAFT_SCHEME.getKey(), "jira");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
    }
}

