/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig.framework;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleWorkflowScheme;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class EditDraftWorkflowSchemeResource
extends RestApiClient<EditDraftWorkflowSchemeResource> {
    private final String root;

    public EditDraftWorkflowSchemeResource(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
        this.root = environmentData.getBaseUrl().toExternalForm();
    }

    protected WebTarget createResource() {
        return this.resourceRoot(this.root).path("rest").path("projectconfig").path("latest").path("draftworkflowscheme");
    }

    private WebTarget doCreateResource(String projectKey) {
        return this.createResource().path(projectKey);
    }

    public SimpleWorkflowScheme edit(String projectKey, String workflowName, String ... issueTypeIds) {
        return (SimpleWorkflowScheme)this.doCreateResource(projectKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new AssignIssueTypesRequest(workflowName, issueTypeIds)), SimpleWorkflowScheme.class);
    }

    public SimpleWorkflowScheme remove(String projectKey, String workflowName) {
        return (SimpleWorkflowScheme)this.doCreateResource(projectKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).method("DELETE", Entity.json((Object)workflowName), SimpleWorkflowScheme.class);
    }

    public ParsedResponse editResponse(String projectKey, String workflowName, String ... issueTypeIds) {
        return this.toResponse(() -> (Response)this.doCreateResource(projectKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new AssignIssueTypesRequest(workflowName, issueTypeIds)), Response.class));
    }

    public ParsedResponse removeResponse(String projectKey, String workflowName) {
        return this.toResponse(() -> (Response)this.doCreateResource(projectKey).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).method("DELETE", Entity.json((Object)workflowName), Response.class));
    }

    public static class AssignIssueTypesRequest {
        @JsonProperty
        private final String name;
        @JsonProperty
        private final List<String> issueTypes;

        public AssignIssueTypesRequest(String name, String ... issueTypes) {
            this.issueTypes = Arrays.asList(issueTypes);
            this.name = StringUtils.stripToNull((String)name);
        }
    }
}

