/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.remote;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.TestRunnerControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.API})
@LoginAs(user="admin")
public class TestIssueService
extends BaseJiraFuncTest {
    private static final String BACK_END_TEST_NAME = "com.atlassian.jira.dev.functest.api.bc.issue." + TestIssueService.class.getSimpleName() + "BackEnd";
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("EmptyJira.xml");
        this.backdoor.project().addProject("WithoutField", "WITHOUT", "admin");
        this.backdoor.project().addProject("WithField", "WITH", "admin");
        this.backdoor.project().addProject("WithRequiredField", "WITHREQ", "admin");
        this.backdoor.project().addProject("Transitions metadata", "METATRANS", "admin");
        this.backdoor.project().addProject("Update metadata", "METAUPDATE", "admin");
        this.backdoor.issues().createIssue("WITHOUT", "The first issue in WITHOUT");
        this.backdoor.issues().createIssue("WITH", "The first issue in WITH");
        this.backdoor.issues().createIssue("WITHREQ", "The first issue in WITHREQ");
        this.backdoor.issues().createIssue("METATRANS", "Transition metadata test issue");
        this.backdoor.issues().createIssue("METAUPDATE", "Update metadata test issue");
        this.backdoor.fieldConfiguration().copyFieldConfiguration("Default Field Configuration", "");
        this.administration.fieldConfigurations().fieldConfiguration("Copy of Default Field Configuration").hideFields("Environment");
        this.administration.fieldConfigurationSchemes().addFieldConfigurationScheme("Without Environment Scheme", "For test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Without Environment Scheme").editAssociation(null, "Copy of Default Field Configuration");
        this.administration.project().associateFieldConfigurationScheme("WithoutField", "Without Environment Scheme");
        this.backdoor.fieldConfiguration().copyFieldConfiguration("Default Field Configuration", "Required Field Config");
        this.administration.fieldConfigurations().fieldConfiguration("Required Field Config").requireField("Component/s");
        this.administration.fieldConfigurationSchemes().addFieldConfigurationScheme("With Required Scheme", "For test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("With Required Scheme").editAssociation(null, "Required Field Config");
        this.administration.project().associateFieldConfigurationScheme("WithRequiredField", "With Required Scheme");
    }

    @Test
    public void testBackEnd() throws Exception {
        TestRunnerControl.TestResult response = this.backdoor.testRunner().getRunTests(BACK_END_TEST_NAME);
        if (!response.passed) {
            Assert.fail((String)response.message);
        }
    }
}

