/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.render;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ContentToRender {
    private final String rendererType;
    private final String unrenderedMarkup;
    private final String issueKey;
    private final String projectId;
    private final String issueType;
    private final boolean forWysiwyg;

    public ContentToRender(String rendererType, String unrenderedMarkup, String issueKey, String projectId, String issueType, boolean forWysiwyg) {
        this.rendererType = rendererType;
        this.unrenderedMarkup = unrenderedMarkup;
        this.issueKey = issueKey;
        this.projectId = projectId;
        this.issueType = issueType;
        this.forWysiwyg = forWysiwyg;
    }

    public static ContentToRender fromWikiMarkup(String unrenderedWikiMarkup, String issueKey) {
        return new ContentToRender("atlassian-wiki-renderer", unrenderedWikiMarkup, issueKey, null, null, false);
    }

    public String getRendererType() {
        return this.rendererType;
    }

    public String getUnrenderedMarkup() {
        return this.unrenderedMarkup;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public boolean isForWysiwyg() {
        return this.forWysiwyg;
    }
}

