/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.page.Error404;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@LoginAs(user="admin")
public class TestBackendActionResolution
extends BaseJiraFuncTest {
    @Test
    public void testBackendActionCanNotBeInvokedByAUrlGivenAFullyQualifiedClassName() throws Exception {
        this.tester.gotoPage("com.atlassian.jira.action.admin.ListenerCreate.jspa?name=SuperHackyEmail+Listener&clazz=com.atlassian.jira.event.listeners.mail.MailListener");
        this.assertListenerCreateActionWasNotInvoked();
        this.assertUnresolvedActionErrorIsReturned();
    }

    @Test
    public void testBackendActionCanNotBeInvokedByAUrlGivenAClassName() throws Exception {
        this.tester.gotoPage("ListenerCreate.jspa?name=SuperHackyEmail+Listener&clazz=com.atlassian.jira.event.listeners.mail.MailListener");
        this.assertListenerCreateActionWasNotInvoked();
        this.assertUnresolvedActionErrorIsReturned();
    }

    private void assertListenerCreateActionWasNotInvoked() throws IOException {
        Assert.assertFalse((boolean)this.tester.getDialog().getResponse().getText().contains("success"));
    }

    private void assertUnresolvedActionErrorIsReturned() throws IOException {
        Assert.assertThat((Object)new Error404(this.tester), Error404.isOn404Page());
    }

    private static class ListenerCreateAction {
        private ListenerCreateAction() {
        }

        private static class Views {
            public static final String SUCCESS = "success";

            private Views() {
            }
        }
    }
}

