/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@Restore(value="TestPublicAccess.xml")
public class TestRedirectAnonymousToLogin
extends BaseJiraFuncTest {
    private static final String PUBLIC_ACCESS_DISABLED_DARK_FEATURE = "public.access.disabled";

    @Before
    public void setUpTest() {
        this.backdoor.darkFeatures().enableForSite(PUBLIC_ACCESS_DISABLED_DARK_FEATURE);
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite(PUBLIC_ACCESS_DISABLED_DARK_FEATURE);
    }

    @Test
    public void testAnonymousUserRedirectedToLoginWhenNoPublicAccess() {
        this.tester.gotoPage("/");
        this.assertThatOnLoginPage(this.getCurrentUrl());
        this.assertCannotBrowseProjectsAndCannotCreateIssues();
    }

    @Test
    public void testAnonymousUserCanBrwoseProjectsAndCreateIssueWhenPublicAccessIsEnabled() {
        this.backdoor.darkFeatures().disableForSite(PUBLIC_ACCESS_DISABLED_DARK_FEATURE);
        this.tester.gotoPage("/");
        this.assertCanBrowseProjectsAndCreateIssues();
    }

    @Test
    public void testAnonymousUserAccessingDashboardRedirectedToLoginWhenNoPublicAccess() {
        this.tester.gotoPage("/secure/Dashboard.jspa");
        this.assertThatOnLoginPage(this.getCurrentUrl());
        this.assertCannotBrowseProjectsAndCannotCreateIssues();
    }

    @Test
    public void testAnonymousUserAccessingProjectRedirectedToLoginWhenNoPublicAccess() throws Exception {
        this.tester.gotoPage("/projects/PUB/issues");
        ImmutableMap expectedQueryParameters = ImmutableMap.builder().put((Object)"permissionViolation", (Object)"true").put((Object)"os_destination", (Object)"/projects/PUB/issues").build();
        this.assertThatOnLoginPageWithQueryParams((Map<String, String>)expectedQueryParameters);
        this.assertCannotBrowseProjectsAndCannotCreateIssues();
    }

    private void assertThatOnLoginPage(String url) {
        Assert.assertThat((Object)url, (Matcher)Matchers.equalTo((Object)(this.getEnvironmentData().getBaseUrl() + "/login.jsp")));
    }

    private void assertThatOnLoginPageWithQueryParams(Map<String, String> queryParameters) throws Exception {
        URL url = new URL(this.getCurrentUrl());
        String currentUrl = String.format("%s://%s:%d%s", url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
        this.assertThatOnLoginPage(currentUrl);
        Map<String, String> actualParameters = URLEncodedUtils.parse((URI)new URI(this.getCurrentUrl()), (String)"UTF-8").stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
        queryParameters.entrySet().forEach(e -> Assert.assertThat((Object)actualParameters, (Matcher)Matchers.hasEntry(e.getKey(), e.getValue())));
    }

    private void assertCanBrowseProjectsAndCreateIssues() {
        this.tester.assertElementPresent("browse_link");
        this.tester.assertElementPresent("create_link");
    }

    private void assertCannotBrowseProjectsAndCannotCreateIssues() {
        this.tester.assertElementNotPresent("browse_link");
        this.tester.assertElementNotPresent("create_link");
    }

    private String getCurrentUrl() {
        return this.tester.getDialog().getWebClient().getCurrentPage().getURL().toString();
    }
}

