/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@RestoreBlankInstance
public class TestRedirectFrom404Errors
extends BaseJiraFuncTest {
    private static final FeatureFlag REDIRECTING_404_ERRORS = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.REDIRECTING_ANONYMOUS_ACCESS_TO_404_ERRORS.featureKey());
    private final String NON_EXITING_PAGE = "abc";
    private String nonExitingPageRedirect;
    private String baseUrl;

    @Before
    public void setUp() throws UnsupportedEncodingException {
        this.baseUrl = this.getEnvironmentData().getBaseUrl().toString() + "/";
        this.nonExitingPageRedirect = URLEncoder.encode(this.baseUrl + "abc", System.getProperty("file.encoding"));
    }

    @Test
    public void testRedirectAnonymousFromNotExistingPage() {
        this.tester.gotoPage("abc");
        Assert.assertEquals((Object)(this.baseUrl + "login.jsp?os_destination=" + this.nonExitingPageRedirect), (Object)this.getCurrentUrl());
    }

    private String getCurrentUrl() {
        return this.tester.getDialog().getWebClient().getCurrentPage().getURL().toString();
    }

    @Test
    public void testShow404ErrorLoggedInUser() {
        this.loginAsAdmin();
        this.tester.gotoPage("abc");
        Assert.assertEquals((Object)(this.baseUrl + "abc"), (Object)this.getCurrentUrl());
    }

    private void loginAsAdmin() {
        this.tester.gotoPage("login.jsp");
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
    }

    @Test
    public void testNoRedirectWhenFeatureFlagEnabled() {
        this.backdoor.darkFeatures().disableForSite(REDIRECTING_404_ERRORS);
        this.tester.gotoPage("abc");
        Assert.assertEquals((Object)(this.baseUrl + "abc"), (Object)this.getCurrentUrl());
    }
}

