/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@Restore(value="TestSignupWithExternalUserManagement.xml")
public class TestSignupWithExternalUserManagement
extends BaseJiraFuncTest {
    @Test
    @LoginAs(user="admin")
    public void testCanSignupWithExternalUserManagementOff() throws Exception {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("externalUM", "false");
        this.tester.submit("Update");
        this.tester.clickLinkWithText("Log Out");
        this.tester.assertTextPresent("You are now logged out");
        this.tester.gotoPage("login.jsp");
        this.tester.assertTextPresent("Not a member?");
        this.tester.assertTextPresent("Signup");
        this.tester.assertTextNotPresent("to request an account.");
        this.tester.clickLink("signup");
        this.tester.setFormElement("username", "dude");
        this.tester.setFormElement("password", "dude");
        this.tester.setFormElement("fullname", "Me");
        this.tester.setFormElement("email", "dude@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("You have successfully signed up");
        this.tester.clickLinkWithText("Click here to log in");
        this.tester.assertLinkNotPresent("create_link");
        this.tester.gotoPage("login.jsp");
        this.tester.setFormElement("os_username", "dude");
        this.tester.setFormElement("os_password", "dude");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.tester.assertLinkPresent("create_link");
    }

    @Test
    public void testCantSignupWithExternalUserManagementOn() throws Exception {
        this.tester.gotoPage("login.jsp");
        this.tester.assertTextPresent("Not a member?");
        this.tester.assertTextPresent("To request an account,");
        this.tester.assertTextNotInElement("login-form", "Signup");
        this.tester.setFormElement("os_username", "dude");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.tester.assertTextPresent("Welcome to Rasta JIRA");
        String url = this.tester.getDialog().getResponse().getURL().getPath();
        Assert.assertTrue((boolean)url.endsWith("login.jsp"));
        this.tester.assertTextPresent("To request an account,");
        this.tester.assertTextNotInElement("login-form", "Signup");
    }

    @Test
    public void testSignupPageBarfsWithExternalUserManagement() throws Exception {
        this.tester.gotoPage("secure/Signup!default.jspa");
        this.tester.assertTextPresent("You can&#39;t sign up right now");
        this.tester.assertFormNotPresent("signup");
        this.navigation.login("admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("externalUM", "false");
        this.tester.submit("Update");
        this.navigation.logout();
        this.navigation.gotoPage("secure/Signup!default.jspa");
        this.tester.assertTextNotPresent("You can&#39;t sign up right now");
        this.tester.assertFormPresent("signup");
    }

    @Test
    @LoginAs(user="admin")
    public void testGeneralConfigurationChecksValidCombination() throws Exception {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.selectOption("mode", "Private");
        this.tester.checkCheckbox("externalUM", "true");
        this.tester.submit("Update");
        this.tester.assertTextNotPresent("You cannot select Public Mode if External User Management is enabled.");
        this.tester.clickLink("edit-app-properties");
        this.tester.selectOption("mode", "Public");
        this.tester.checkCheckbox("externalUM", "true");
        this.tester.submit("Update");
        this.tester.assertTextPresent("You cannot select Public Mode if External User Management is enabled.");
    }
}

