/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@LoginAs(user="admin")
public class TestWebResourceRetrievalDoesNotExposeProtectedResources
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testWebInfResourceCannotBeRetrieved() throws Exception {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        this.tester.gotoPage("s/1519/3/1.0/_/WEB-INF/classes/seraph-config.xml");
        Assert.assertEquals((long)this.tester.getDialog().getResponse().getResponseCode(), (long)404L);
        Assert.assertTrue((boolean)this.tester.getDialog().getResponse().getText().contains("dead link"));
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
    }

    @Test
    public void testWebInfResourceCannotBeRetrievedWithParentTransversal() throws Exception {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        this.tester.gotoPage("s/1519/3/1.0/_/WEB-INF/images/../classes/seraph-config.xml");
        Assert.assertEquals((long)this.tester.getDialog().getResponse().getResponseCode(), (long)404L);
        Assert.assertTrue((boolean)this.tester.getDialog().getResponse().getText().contains("dead link"));
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
    }
}

