/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security.plugin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import com.google.common.base.Preconditions;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.REFERENCE_PLUGIN})
@LoginAs(user="admin")
public class TestHttpSecurityHeadersConfig
extends BaseJiraFuncTest {
    private static final String REFAPP_EXCLUDED_PATH = "/plugins/servlet/reference-servlet-with-filter";
    private static final String REFAPP_NOT_EXCLUDED_PATH = "/plugins/servlet/reference-servlet";
    private static final String JIRA_EXCLUDED_PATH = "/issues/";
    private static final String JIRA_NOT_EXCLUDED_PATH = "/secure/Dashboard.jspa";
    private static final String X_XSS_PROTECTION_VALUE = "1; mode=block";
    private static final String X_CONTENT_TYPE_OPTIONS_VALUE = "nosniff";
    private static final String X_FRAME_OPTIONS_VALUE = "SAMEORIGIN";
    private static final String CONTENT_SECURITY_POLICY_VALUE = "frame-ancestors 'self'";
    private static final String STRICT_TRANSPORT_SECURITY_DEFAULT_VALUE = "max-age=31536000";
    @Inject
    private FuncTestRestClient restClient;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        Preconditions.checkState((boolean)this.backdoor.plugins().getPluginState(ReferencePluginConstants.REFERENCE_PLUGIN_KEY).equals("ENABLED"));
    }

    @Test
    public void testExcludedPathWithinRefapp() {
        this.assertOnlyCommonHeadersSetForPath(REFAPP_EXCLUDED_PATH);
    }

    @Test
    public void testExcludedPathOutsideRefapp() {
        this.assertOnlyCommonHeadersSetForPath("/issues/?jql=text");
    }

    @Test
    public void testNotExcludedPathWithinRefapp() {
        this.assertAllHeadersSetForPath(REFAPP_NOT_EXCLUDED_PATH);
    }

    @Test
    public void testNotExcludedPathOutsideRefapp() {
        this.assertAllHeadersSetForPath(JIRA_NOT_EXCLUDED_PATH);
    }

    @Test
    public void testExcludedPathOutsideRefappWhenRefappIsDisabled() {
        this.runCodeWhenRefappIsDisabled(() -> this.assertAllHeadersSetForPath(JIRA_EXCLUDED_PATH));
    }

    @Test
    public void testExcludedPathOutsideRefappWhenRefappModuleIsDisabled() {
        this.runCodeWhenRefappModuleIsDisabled(() -> this.assertAllHeadersSetForPath(JIRA_EXCLUDED_PATH));
    }

    @Test
    public void testExcludedPathWithinRefappWhenRefappModuleIsDisabled() {
        this.runCodeWhenRefappModuleIsDisabled(() -> this.assertAllHeadersSetForPath(REFAPP_EXCLUDED_PATH));
    }

    private void runCodeWhenRefappIsDisabled(Runnable runnable) {
        try {
            this.backdoor.plugins().disablePlugin(ReferencePluginConstants.REFERENCE_PLUGIN_KEY);
            Assert.assertTrue((boolean)this.administration.plugins().isPluginDisabled(ReferencePluginConstants.REFERENCE_PLUGIN_KEY));
            runnable.run();
        }
        finally {
            this.backdoor.plugins().enablePlugin(ReferencePluginConstants.REFERENCE_PLUGIN_KEY);
        }
    }

    private void runCodeWhenRefappModuleIsDisabled(Runnable runnable) {
        try {
            this.backdoor.plugins().disablePluginModule(ReferencePluginConstants.CLICKJACKING_EXCLUDED_PATHS_KEY);
            Assert.assertTrue((boolean)this.administration.plugins().isPluginModuleDisabled(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, ReferencePluginConstants.CLICKJACKING_EXCLUDED_PATHS_KEY));
            runnable.run();
        }
        finally {
            this.backdoor.plugins().enablePluginModule(ReferencePluginConstants.CLICKJACKING_EXCLUDED_PATHS_KEY);
        }
    }

    private void assertOnlyCommonHeadersSetForPath(String path) {
        WebResponse webResponse = this.doGet(path);
        this.verifyCommonHeadersAreSet(webResponse);
        this.verifyClickjackingHeadersNotSet(webResponse);
        this.verifyClickjackingHeaderIsSet(webResponse);
    }

    private void assertAllHeadersSetForPath(String path) {
        WebResponse webResponse = this.doGet(path);
        this.verifyCommonHeadersAreSet(webResponse);
        this.verifyClickjackingHeadersAreSet(webResponse);
        this.verifyClickjackingHeaderIsSet(webResponse);
    }

    private void verifyCommonHeadersAreSet(WebResponse webResponse) {
        Assert.assertThat((Object)webResponse.getHeaderField("X-Content-Type-Options"), (Matcher)CoreMatchers.equalTo((Object)X_CONTENT_TYPE_OPTIONS_VALUE));
        Assert.assertThat((Object)webResponse.getHeaderField("X-XSS-Protection"), (Matcher)CoreMatchers.equalTo((Object)X_XSS_PROTECTION_VALUE));
    }

    private void verifyClickjackingHeadersAreSet(WebResponse webResponse) {
        Assert.assertThat((Object)webResponse.getHeaderField("X-Frame-Options"), (Matcher)CoreMatchers.equalTo((Object)X_FRAME_OPTIONS_VALUE));
        Assert.assertThat((Object)webResponse.getHeaderField("Content-Security-Policy"), (Matcher)CoreMatchers.equalTo((Object)CONTENT_SECURITY_POLICY_VALUE));
    }

    private void verifyClickjackingHeaderIsSet(WebResponse webResponse) {
        Assert.assertThat((Object)webResponse.getHeaderField("Strict-Transport-Security"), (Matcher)CoreMatchers.equalTo((Object)STRICT_TRANSPORT_SECURITY_DEFAULT_VALUE));
    }

    private void verifyClickjackingHeadersNotSet(WebResponse webResponse) {
        Assert.assertThat((Object)webResponse.getHeaderField("X-Frame-Options"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)webResponse.getHeaderField("Content-Security-Policy"), (Matcher)CoreMatchers.nullValue());
    }

    private WebResponse doGet(String path) {
        try {
            return this.restClient.GET(path);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

