/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security.plugin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.JiraRestClientSupplier;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.REFERENCE_PLUGIN})
@LoginAs(user="admin")
public class TestPermissionOverride
extends BaseJiraFuncTest {
    private static final String TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE = "com.atlassian.jira.dev.reference-plugin:brad.odlaw.cant.transition.issue";
    private static final String COMMENT_ISSUE_PERMISSION_OVERRIDE_MODULE = "com.atlassian.jira.dev.reference-plugin:brad.odlaw.cant.comment";
    private static final String EDIT_ISSUE_PERMISSION_OVERRIDE_MODULE = "com.atlassian.jira.dev.reference-plugin:brad.odlaw.cant.edit.issue";
    private static final String BRAD = "brad_the_odlaw";
    @Rule
    public JiraRestClientSupplier jiraRestClientSupplier = new JiraRestClientSupplier(this::getEnvironmentData, "brad_the_odlaw", "brad_the_odlaw");
    private IssueClient issueClient;
    private CommentClient commentClient;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.jiraRestClientSupplier.get();
        this.administration.restoreBlankInstance();
        this.backdoor.usersAndGroups().addUser(BRAD, BRAD, BRAD, "odlaw@atlassiqan.com").addUserToGroup(BRAD, "jira-developers");
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.commentClient = new CommentClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testPermissionToEditIssueOverridden() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "issue summary");
        this.backdoor.plugins().disablePluginModule(EDIT_ISSUE_PERMISSION_OVERRIDE_MODULE);
        ParsedResponse response = ((IssueClient)this.issueClient.loginAs(BRAD, BRAD)).updateResponse(issue.key(), this.summary("new summary"));
        Assert.assertThat((Object)response.statusCode, this.statusCode(Response.Status.NO_CONTENT));
        this.backdoor.plugins().enablePluginModule(EDIT_ISSUE_PERMISSION_OVERRIDE_MODULE);
        ParsedResponse updateWithoutPermissionResponse = ((IssueClient)this.issueClient.loginAs(BRAD, BRAD)).updateResponse(issue.key(), this.summary("summary which will never be set"));
        Assert.assertThat((Object)updateWithoutPermissionResponse.statusCode, (Matcher)Matchers.not(this.statusCodeFamily(200)));
    }

    @Test
    public void testPermissionToCommentIssueOverridden() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "issue summary");
        this.backdoor.plugins().disablePluginModule(COMMENT_ISSUE_PERMISSION_OVERRIDE_MODULE);
        ParsedResponse response = ((CommentClient)this.commentClient.loginAs(BRAD, BRAD)).post(issue.key(), this.comment("I comment because I can"));
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)Response.Status.CREATED.getStatusCode()));
        this.backdoor.plugins().enablePluginModule(COMMENT_ISSUE_PERMISSION_OVERRIDE_MODULE);
        ParsedResponse commentWithoutPermissionResponse = ((CommentClient)this.commentClient.loginAs(BRAD, BRAD)).post(issue.key(), this.comment("I try to comment"));
        Assert.assertThat((Object)commentWithoutPermissionResponse.statusCode, (Matcher)Matchers.not(this.statusCodeFamily(200)));
    }

    @Test
    public void testPermissionToTransitionIssueOverridden() throws IOException {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "issue summary");
        this.backdoor.plugins().disablePluginModule(TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE);
        Assert.assertThat(this.getIssueTransitions(this.jiraRestClientSupplier.get(), issue.key()), (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()));
        this.backdoor.plugins().enablePluginModule(TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE);
        Assert.assertThat(this.getIssueTransitions(this.jiraRestClientSupplier.get(), issue.key()), (Matcher)Matchers.emptyIterable());
    }

    private IssueUpdateRequest summary(String summary) {
        return new IssueUpdateRequest().fields(new IssueFields().summary(summary));
    }

    private Comment comment(String commentText) {
        Comment comment = new Comment();
        comment.body = commentText;
        comment.visibility = new Visibility("group", "jira-users");
        return comment;
    }

    private Matcher<? super Integer> statusCode(Response.Status status) {
        return Is.is((Object)status.getStatusCode());
    }

    private Matcher<? super Integer> statusCodeFamily(int family) {
        int statusCodeFamilyLowerBound = family / 100 * 100;
        return Matchers.allOf((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(statusCodeFamilyLowerBound + 100)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(statusCodeFamilyLowerBound)));
    }

    private Iterable<Transition> getIssueTransitions(JiraRestClient jiraRestClient, String issueKey) {
        IssueRestClient issueClient = jiraRestClient.getIssueClient();
        Issue restClientIssue = (Issue)issueClient.getIssue(issueKey).claim();
        return (Iterable)issueClient.getTransitions(restClientIssue).claim();
    }
}

