/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SECURITY, Category.SUB_TASKS})
@LoginAs(user="admin")
public class TestIssueToSubTaskConversionSecurityLevel
extends BaseJiraFuncTest {
    private static final String NO_SECURITY_ISSUE = "HSP-1";
    private static final String DEV_SECURITY_ISSUE = "HSP-2";
    private static final String ADMIN_SECURITY_ISSUE = "HSP-3";
    private static final String DEV_SECURITY_ISSUE_2 = "HSP-4";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreData("TestIssueToSubTaskConversionSecurityLevel.xml");
    }

    @Test
    public void testIssueToSubTaskConversionSecurityLevelIntroduced() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(NO_SECURITY_ISSUE);
        this.tester.assertTextPresent(NO_SECURITY_ISSUE);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(NO_SECURITY_ISSUE);
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", DEV_SECURITY_ISSUE);
        this.navigation.issue().selectIssueType("Sub-task", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security", "Developers");
        this.tester.submit("Finish");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level:", "Developers");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(NO_SECURITY_ISSUE);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }

    @Test
    public void testIssueToSubTaskConversionSecurityLevelRemoved() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(DEV_SECURITY_ISSUE);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(DEV_SECURITY_ISSUE);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level:", "Developers");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", NO_SECURITY_ISSUE);
        this.navigation.issue().selectIssueType("Sub-task", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security", "Developers");
        this.tester.submit("Finish");
        this.tester.assertTextNotPresent("Security Level:");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(DEV_SECURITY_ISSUE);
        this.tester.assertTextPresent(DEV_SECURITY_ISSUE);
    }

    @Test
    public void testIssueToSubTaskConversionSecurityLevelChanged() {
        this.navigation.logout();
        this.navigation.login("jane", "jane");
        this.navigation.issue().gotoIssue(DEV_SECURITY_ISSUE);
        this.tester.assertTextPresent(DEV_SECURITY_ISSUE);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(DEV_SECURITY_ISSUE);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level:", "Developers");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", ADMIN_SECURITY_ISSUE);
        this.navigation.issue().selectIssueType("Sub-task", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security", "Developers");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Developers", "Administrators");
        this.tester.submit("Finish");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level:", "Administrators");
        this.navigation.logout();
        this.navigation.login("jane", "jane");
        this.navigation.issue().gotoIssue(DEV_SECURITY_ISSUE);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }

    @Test
    public void testIssueToSubTaskConversionSecurityLevelSame() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(DEV_SECURITY_ISSUE);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(DEV_SECURITY_ISSUE);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level:", "Developers");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", DEV_SECURITY_ISSUE_2);
        this.navigation.issue().selectIssueType("Sub-task", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.tester.assertTextNotPresent("Developers");
        this.tester.submit("Finish");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security Level:", "Developers");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(DEV_SECURITY_ISSUE);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }
}

