/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.subtask.SubTaskAssertions;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SUB_TASKS})
@LoginAs(user="admin")
public class TestIssueToSubTaskConversionStep2
extends BaseJiraFuncTest {
    private static final String ISSUE_TO_CONVERT_ID = "10050";
    private static final String ISSUE_TO_CONVERT_KEY = "MKY-4";
    private static final String ISSUE_TO_CONVERT_INVALID_STATUS_ID = "10051";
    private static final String ISSUE_TO_CONVERT_INVALID_STATUS_KEY = "MKY-5";
    private static final String PARENT_ISSUE = "MKY-3";
    private static final String SUBTASK_TYPE = "Sub-task";
    private static final String SUBTASK_TYPE_ID = "5";
    private static final String SUBTASK_TYPE_3 = "Sub-task 3";
    private static final String SUBTASK_TYPE_3_ID = "7";
    private static final String VALID_STATUS = "1";
    private static final String INVALID_STATUS = "3";
    private static final String NON_EXISTANT_STATUS = "932";
    protected static final String ISSUE_STATUS_VALUE_ID = "opsbar-transitions_more";
    @Inject
    SubTaskAssertions subTaskAssertions;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreData("TestIssueToSubTaskConversion.xml");
    }

    @Test
    public void testSameWorkflow() {
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, SUBTASK_TYPE_ID);
        this.tester.assertTextPresent("Step 2 is not required.");
        this.assertThirdStepPaneWithout2nd(ISSUE_TO_CONVERT_KEY, PARENT_ISSUE, SUBTASK_TYPE, "Open");
        String convertIssueElementContent = this.tester.getDialog().getElement("stepped-process").getTextContent();
        Assert.assertThat((Object)convertIssueElementContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Closed")));
        Assert.assertThat((Object)convertIssueElementContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Reopened")));
        Assert.assertThat((Object)convertIssueElementContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Resolved")));
        this.tester.submit("Next >>");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_KEY, 4);
        this.tester.assertTextNotInTable("convert_confirm_table", "Status");
        this.tester.submit("Finish");
        IdLocator locator = new IdLocator(this.tester, "type-val");
        this.textAssertions.assertTextPresent(locator, SUBTASK_TYPE);
        locator = new IdLocator(this.tester, ISSUE_STATUS_VALUE_ID);
        this.textAssertions.assertTextPresent(locator, "Open");
        this.tester.clickLinkWithText("History");
        this.textAssertions.assertTextPresentNumOccurences(this.tester.getDialog().getElement("jira").getTextContent(), "Resolution", 1);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"History", "Issue Type", "Bug", SUBTASK_TYPE});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"History", "Parent", PARENT_ISSUE});
    }

    @Test
    public void testDiffWorkflowValidStatus() {
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID);
        this.tester.assertTextPresent("Step 2 is not required.");
        this.assertThirdStepPaneWithout2nd(ISSUE_TO_CONVERT_KEY, PARENT_ISSUE, SUBTASK_TYPE_3, "Open");
        String convertIssueElementContent = this.tester.getDialog().getElement("stepped-process").getTextContent();
        Assert.assertThat((Object)convertIssueElementContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Closed")));
        Assert.assertThat((Object)convertIssueElementContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Reopened")));
        Assert.assertThat((Object)convertIssueElementContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Resolved")));
        this.tester.submit("Next >>");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_KEY, 4);
        this.tester.assertTextInTable("convert_confirm_table", "Status");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Status", "(Workflow)", "Open", "status-inactive", "(jira)", "Open", "status-active", "(Subtask Workflow)"});
        this.tester.submit("Finish");
        IdLocator locator = new IdLocator(this.tester, "type-val");
        this.textAssertions.assertTextPresent(locator, SUBTASK_TYPE_3);
        locator = new IdLocator(this.tester, ISSUE_STATUS_VALUE_ID);
        this.textAssertions.assertTextPresent(locator, "Open");
        this.tester.clickLinkWithText("History");
        this.textAssertions.assertTextPresentNumOccurences(this.tester.getDialog().getElement("jira").getTextContent(), "Resolution", 1);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"History", "Workflow", "jira", "Subtask Workflow"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"History", "Issue Type", "Bug", SUBTASK_TYPE_3});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"History", "Parent", PARENT_ISSUE});
    }

    @Test
    public void testDiffWorkflowInvalidStatus() {
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID);
        this.tester.assertTextPresent("Step 2 of 4");
        this.tester.assertOptionsEqual("targetStatusId", new String[]{"Open", "Resolved", "Reopened", "Closed"});
        this.tester.assertRadioOptionValueNotPresent("targetStatusId", "In Progress");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Select New Status", "In Progress", "Workflow", "jira", "Workflow", "Subtask Workflow"});
        this.assertSecondStepPane(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, PARENT_ISSUE, SUBTASK_TYPE_3);
        this.tester.setFormElement("targetStatusId", VALID_STATUS);
        this.tester.submit("Next >>");
        String convertIssueElementContent = this.tester.getDialog().getElement("stepped-process").getTextContent();
        Assert.assertThat((Object)convertIssueElementContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Closed")));
        Assert.assertThat((Object)convertIssueElementContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Reopened")));
        Assert.assertThat((Object)convertIssueElementContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Resolved")));
        this.tester.submit("Next >>");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 4);
        this.tester.assertTextInTable("convert_confirm_table", "Status");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Status", "(Workflow)", "In Progress", "status-inactive", "(jira)", "Open", "status-active", "(Subtask Workflow)"});
        this.tester.submit("Finish");
        IdLocator locator = new IdLocator(this.tester, "type-val");
        this.textAssertions.assertTextPresent(locator, SUBTASK_TYPE_3);
        locator = new IdLocator(this.tester, ISSUE_STATUS_VALUE_ID);
        this.textAssertions.assertTextPresent(locator, "Open");
        this.tester.clickLinkWithText("History");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"History", "Workflow", "jira", "Subtask Workflow"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"History", "Status", "In Progress", "Open"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"History", "Issue Type", "Bug", SUBTASK_TYPE_3});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"History", "Parent", PARENT_ISSUE});
    }

    @Test
    public void testBrowseBackOnPane() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, VALID_STATUS);
        this.tester.submit("Next >>");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 4);
        this.tester.clickLinkWithText("Select Parent and Sub-task Type");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 1);
        this.tester.assertTextPresent("Step 1 of 4");
        this.tester.assertTextPresent(PARENT_ISSUE);
        this.tester.getDialog().dumpResponse();
        this.tester.assertTextPresent("option value=\"7\" SELECTED");
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, VALID_STATUS);
        this.tester.submit("Next >>");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 4);
        this.tester.clickLinkWithText("Select New Status");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 2);
        this.tester.assertTextPresent("Step 2 of 4");
        this.tester.assertTextPresent("option value=\"1\" SELECTED");
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, VALID_STATUS);
        this.tester.submit("Next >>");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 4);
        this.tester.clickLinkWithText("Update Fields");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 3);
        this.tester.assertTextPresent("Step 3 of 4");
    }

    @Test
    public void testResultsValidStatus() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, VALID_STATUS);
        this.tester.assertTextPresent("Step 3 of 4");
        this.assertThirdStepPaneWith2nd(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, PARENT_ISSUE, SUBTASK_TYPE_3, "Open");
    }

    @Test
    public void testResultsInvalidStatus() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, INVALID_STATUS);
        this.tester.assertTextPresent("Step 2 of 4");
        this.tester.assertTextPresent("Selected status (In Progress) is not valid for target workflow");
        this.assertSecondStepPane(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, PARENT_ISSUE, SUBTASK_TYPE_3);
    }

    @Test
    public void testResultsNoStatus() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, "");
        this.tester.assertTextPresent("Step 2 of 4");
        this.tester.assertTextPresent("No status specified");
        this.assertSecondStepPane(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, PARENT_ISSUE, SUBTASK_TYPE_3);
    }

    @Test
    public void testResultsNonExistantStatus() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, NON_EXISTANT_STATUS);
        this.tester.assertTextPresent("Step 2 of 4");
        this.tester.assertTextPresent("Status with id 932 does not exist");
        this.assertSecondStepPane(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, PARENT_ISSUE, SUBTASK_TYPE_3);
    }

    @Test
    public void testResultsValidStatusForIssueThatDoesntNeedChanging() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, SUBTASK_TYPE_ID, INVALID_STATUS);
        this.tester.assertTextPresent("Status should not be changed for this conversion");
    }

    private void assertSecondStepPane(String key, String parent, String type) {
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(key, 2);
        this.tester.assertLinkPresentWithText("Select Parent and Sub-task Type");
        this.tester.assertLinkNotPresentWithText("Select New Status");
        this.tester.assertLinkNotPresentWithText("Update Fields");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Parent Issue:", "<strong>" + parent + "</strong>", "Sub-task Type:", "<strong>" + type + "</strong>", "Select New Status"});
    }

    private void assertThirdStepPaneWith2nd(String key, String parent, String type, String status) {
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(key, 3);
        this.tester.assertLinkPresentWithText("Select Parent and Sub-task Type");
        this.tester.assertLinkPresentWithText("Select New Status");
        this.tester.assertLinkNotPresentWithText("Update Fields");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Parent Issue:", "<strong>" + parent + "</strong>", "Sub-task Type:", "<strong>" + type + "</strong>", "Status:", "<strong>" + status + "</strong>"});
    }

    private void assertThirdStepPaneWithout2nd(String key, String parent, String type, String status) {
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(key, 3);
        this.tester.assertLinkPresentWithText("Select Parent and Sub-task Type");
        this.tester.assertLinkNotPresentWithText("Select New Status");
        this.tester.assertLinkNotPresentWithText("Update Fields");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Parent Issue:", "<strong>" + parent + "</strong>", "Sub-task Type:", "<strong>" + type + "</strong>", "Status:", "<strong>" + status + "</strong>"});
    }

    private void gotoConvertIssueStep2(String issueId, String parent, String issueType) {
        this.tester.gotoPage("/secure/ConvertIssueSetIssueType.jspa?id=" + issueId + "&parentIssueKey=" + parent + "&issuetype=" + issueType);
    }

    private void gotoConvertIssueStep3(String issueId, String parentKey, String issueType, String status) {
        this.tester.gotoPage("/secure/ConvertIssueSetStatus.jspa?id=" + issueId + "&parentIssueKey=" + parentKey + "&issuetype=" + issueType + "&targetStatusId=" + status);
    }
}

