/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
public class TestPreventLeak
extends BaseJiraFuncTest {
    @Test
    @RestoreBlankInstance
    public void testNoIssueKeyLeakWhenAccessingConvertSubTaskWithDefaultAction() {
        String issueId = this.createTestIssueAndGetId();
        this.tester.gotoPage("/ConvertSubTask!default.jspa?id=" + issueId);
        this.tester.assertTextNotPresent("TEST-1");
    }

    @Test
    @RestoreBlankInstance
    public void testNoIssueKeyLeakWhenAccessingConvertSubTask() {
        String issueId = this.createTestIssueAndGetId();
        this.tester.gotoPage("/ConvertSubTask.jspa?id=" + issueId);
        this.tester.assertTextNotPresent("TEST-1");
    }

    @Test
    @RestoreBlankInstance
    public void testNoIssueKeyLeakWhenAccessingConvertIssueWithDefaultAction() {
        String issueId = this.createTestIssueAndGetId();
        this.tester.gotoPage("/ConvertIssue!default.jspa?id=" + issueId);
        this.tester.assertTextNotPresent("TEST-1");
    }

    @Test
    @RestoreBlankInstance
    public void testNoIssueKeyLeakWhenAccessingConvertIssue() {
        String issueId = this.createTestIssueAndGetId();
        this.tester.gotoPage("/ConvertIssue.jspa?id=" + issueId);
        this.tester.assertTextNotPresent("TEST-1");
    }

    private String createTestIssueAndGetId() {
        this.backdoor.project().addProject("TEST", "TEST", "admin");
        return this.backdoor.issues().createIssue("TEST", "TestIssue").id();
    }
}

