/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.util.ProgressPageControl;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.SUB_TASKS})
@LoginAs(user="admin")
@Restore(value="TestSecurityLevelOfSubtasks.xml")
public class TestSecurityLevelOfSubtasks
extends BaseJiraFuncTest {
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private HtmlPage page;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Test
    public void testBulkEditWithSubtasksOnly() {
        int rat7Row;
        int rat9Row;
        this.showAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10051", "on");
        this.tester.checkCheckbox("bulkedit_10032", "on");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 2 of 4: Choose Operation", "Choose the operation you wish to perform on the selected 2 issue(s)."});
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4: Operation Details", "Choose the bulk action(s) you wish to perform on the selected 2 issue(s)."});
        WebTable webTable = this.getWebTableWithID("availableActionsTable");
        this.assertions.getTableAssertions().assertTableCellHasText(webTable, 1, 1, "Change Security Level");
        Assert.assertEquals((Object)"The security level of subtasks is inherited from parents.", (Object)webTable.getCellAsText(1, 2).trim());
        this.tester.checkCheckbox("actions", "priority");
        this.tester.selectOption("priority", "Minor");
        this.tester.checkCheckbox("actions", "assignee");
        this.tester.selectOption("assignee", "Henry Ford");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 4 of 4: Confirmation", "Updated Fields", "Priority", "Minor", "Assignee", "Henry Ford", "The above table summarises the changes you are about to make"});
        webTable = this.getWebTableWithID("issuetable");
        if (webTable.getCellAsText(1, 1).trim().equals("RAT-9")) {
            rat9Row = 1;
            rat7Row = 2;
        } else {
            rat9Row = 2;
            rat7Row = 1;
        }
        Assert.assertEquals((Object)"RAT-9", (Object)webTable.getCellAsText(rat9Row, 1).trim());
        Assert.assertEquals((Object)"Mark", (Object)webTable.getCellAsText(rat9Row, 3).trim());
        Assert.assertEquals((Object)"Level KingRat", (Object)webTable.getCellAsText(rat9Row, 11).trim());
        Assert.assertEquals((Object)"RAT-7", (Object)webTable.getCellAsText(rat7Row, 1).trim());
        Assert.assertEquals((Object)"Henry Ford", (Object)webTable.getCellAsText(rat7Row, 3).trim());
        Assert.assertEquals((Object)"Level Mouse", (Object)webTable.getCellAsText(rat7Row, 11).trim());
        this.tester.submit("Confirm");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        webTable = this.getWebTableWithID("issuetable");
        Assert.assertEquals((Object)"RAT-9", (Object)webTable.getCellAsText(1, 1).trim());
        Assert.assertEquals((Object)"Henry Ford", (Object)webTable.getCellAsText(1, 3).trim());
        Assert.assertEquals((Object)"Level KingRat", (Object)webTable.getCellAsText(1, 11).trim());
        Assert.assertEquals((Object)"RAT-7", (Object)webTable.getCellAsText(3, 1).trim());
        Assert.assertEquals((Object)"Henry Ford", (Object)webTable.getCellAsText(3, 3).trim());
        Assert.assertEquals((Object)"Level Mouse", (Object)webTable.getCellAsText(3, 11).trim());
    }

    @Test
    public void testBulkEditWithStandardIssueAndSubTask() {
        this.showAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10032", "on");
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 2 of 4: Choose Operation", "Choose the operation you wish to perform on the selected 2 issue(s)."});
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Change Security Level");
        this.tester.checkCheckbox("actions", "security");
        this.tester.selectOption("security", "None");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 4 of 4: Confirmation");
        this.tester.assertTextPresent("Updated Fields");
        this.tester.assertTextPresent("None");
        this.tester.assertTextPresent("The above table summarises the changes you are about to make to the following <strong>2</strong> issues. Do you wish to continue?");
        this.tester.submit("Confirm");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        WebTable issueTable = this.getWebTableWithID("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 2, "RAT-8");
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(1, 11).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-8");
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 11).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-7");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 2, "RAT-5");
        Assert.assertEquals((Object)"Level Mouse", (Object)issueTable.getCellAsText(3, 11).trim());
    }

    @Test
    public void testEditParentIssue() {
        this.showAllIssues();
        this.tester.clickLinkWithText("RAT-8");
        this.tester.assertTextPresent("A top level task.");
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Edit Issue");
        this.tester.selectOption("security", "None");
        this.tester.submit("Update");
        this.navigation.issue().returnToSearch();
        WebTable issueTable = this.getWebTableWithID("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 2, "RAT-8");
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(1, 11).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-8");
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 11).trim());
        this.tester.clickLinkWithText("RAT-8");
        this.tester.assertTextPresent("A top level task.");
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Edit Issue");
        this.tester.selectOption("security", "Level KingRat");
        this.tester.submit("Update");
        this.navigation.issue().returnToSearch();
        issueTable = this.getWebTableWithID("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 2, "RAT-8");
        Assert.assertEquals((Object)"Level KingRat", (Object)issueTable.getCellAsText(1, 11).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-8");
        Assert.assertEquals((Object)"Level KingRat", (Object)issueTable.getCellAsText(2, 11).trim());
    }

    @Test
    public void testWorkflowTransitionParentIssue() {
        this.showAllIssues();
        this.tester.clickLinkWithText("RAT-8");
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.assertTextPresent("Resolve Issue");
        this.tester.assertTextPresent("Resolving an issue indicates that the developers are satisfied the issue is finished.");
        this.tester.selectOption("security", "None");
        this.tester.submit("Transition");
        this.tester.assertTextNotPresent("Security Level");
        this.navigation.issue().returnToSearch();
        WebTable issueTable = this.getWebTableWithID("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 2, "RAT-8");
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(1, 11).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-8");
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 11).trim());
    }

    @Test
    public void testWorkflowTransitionSubtask() {
        this.showAllIssues();
        this.tester.clickLinkWithText("RAT-9");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertTextPresent("Level KingRat");
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.assertTextPresent("Resolve Issue");
        this.tester.assertTextPresent("Resolving an issue indicates that the developers are satisfied the issue is finished.");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertTextPresent("Level KingRat");
        this.navigation.issue().returnToSearch();
        WebTable issueTable = this.getWebTableWithID("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 2, "RAT-8");
        Assert.assertEquals((Object)"Level KingRat", (Object)issueTable.getCellAsText(1, 11).trim());
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-8");
        Assert.assertEquals((Object)"Level KingRat", (Object)issueTable.getCellAsText(2, 11).trim());
    }

    @Test
    public void testChangeProjectsSecurityLevelScheme() {
        this.assertPrecondition();
        Long projectId = this.backdoor.project().getProjectId("RAT");
        Long schemeId = this.backdoor.project().getSchemes((Long)projectId).issueSecurityScheme.id;
        this.tester.gotoPage("/secure/project/SelectProjectIssueSecurityScheme!default.jspa?projectId=" + projectId + "&schemeId=" + schemeId);
        this.tester.selectOption("newSchemeId", "DogSecurityScheme");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Associate Issue Security Scheme to Project");
        this.tester.selectOption("level_10025", "Level Red");
        this.tester.selectOption("level_10026", "Level Green");
        this.tester.submit("Associate");
        ProgressPageControl.waitAndReload(this.tester, "assignissuesecurityprogressform", "Refresh", "Acknowledge");
        Assert.assertThat((Object)new ProjectClient((JIRAEnvironmentData)this.environmentData).get((String)"RAT").name, (Matcher)CoreMatchers.equalTo((Object)"Rattus"));
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 2, "RAT-8");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level Red");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-8");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level Red");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-7");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 2, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 11, "Level Green");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 1, "RAT-6");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 11, "Level Green");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 1, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 11, "Level Green");
    }

    private void assertPrecondition() {
        this.showAllIssues();
    }

    private void showAllIssues() {
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 2, "RAT-8");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-8");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-7");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 2, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 1, "RAT-6");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 1, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 1, "COW-37");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 2, "Lets get a third milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 1, "COW-36");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 2, "Get another milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 8, 1, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 8, 2, "No more milk");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 8, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 9, 1, "COW-34");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 9, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 9, 2, "Get new milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 9, 11, "MyFriendsOnly");
    }

    private WebTable getWebTableWithID(String id) {
        return this.tester.getDialog().getWebTableBySummaryOrId(id);
    }
}

