/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
@LoginAs(user="admin")
public class TestSubTaskQuickCreation
extends BaseJiraFuncTest {
    public static final String JIRA_LOZENGE_DARK_FEATURE = "jira.issue.status.lozenge";
    private static final String ISSUE_PARENT = "HSP-6";
    private static final String SUB_TASKS_TABLE_ID = "issuetable";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestTimeTrackingAggregates.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testSubTaskDisplayOptions() {
        this.subTaskDisplayOptions(false);
    }

    @Test
    public void testSubTaskDisplayOptionsWithStatusLozengesEnabled() throws Exception {
        boolean isLozengeEnabled = this.backdoor.darkFeatures().isGlobalEnabled(JIRA_LOZENGE_DARK_FEATURE);
        try {
            this.backdoor.darkFeatures().enableForSite(JIRA_LOZENGE_DARK_FEATURE);
            this.subTaskDisplayOptions(true);
        }
        finally {
            if (!isLozengeEnabled) {
                this.backdoor.darkFeatures().disableForSite(JIRA_LOZENGE_DARK_FEATURE);
            }
        }
    }

    private void subTaskDisplayOptions(boolean statusLozengesEnabled) {
        this.navigation.issue().resolveIssue("HSP-7", "Fixed", "");
        this.navigation.issue().gotoIssue(ISSUE_PARENT);
        if (statusLozengesEnabled) {
            this.textAssertions.assertTextSequence(this.locator.table(SUB_TASKS_TABLE_ID), "sub 1", "Resolved", "sub 2", "Open");
        } else {
            this.textAssertions.assertTextSequence(this.locator.table(SUB_TASKS_TABLE_ID).getHTML(), "sub 1", "<img", "Resolved", "sub 2", "<img", "Open");
        }
        this.tester.clickLink("subtasks-show-open");
        if (statusLozengesEnabled) {
            this.textAssertions.assertTextSequence(this.locator.table(SUB_TASKS_TABLE_ID), "sub 2", "Open");
            this.textAssertions.assertTextNotPresent(this.locator.table(SUB_TASKS_TABLE_ID), "sub 1");
            this.textAssertions.assertTextNotPresent(this.locator.table(SUB_TASKS_TABLE_ID), "Resolved");
        } else {
            this.textAssertions.assertTextSequence(this.locator.table(SUB_TASKS_TABLE_ID).getHTML(), "sub 2", "<img", "Open");
            this.textAssertions.assertTextNotPresent(this.locator.table(SUB_TASKS_TABLE_ID).getHTML(), "sub 1");
            this.textAssertions.assertTextNotPresent(this.locator.table(SUB_TASKS_TABLE_ID).getHTML(), "Resolved");
        }
        this.tester.clickLink("subtasks-show-all");
        if (statusLozengesEnabled) {
            this.textAssertions.assertTextSequence(this.locator.table(SUB_TASKS_TABLE_ID), "sub 1", "Resolved", "sub 2", "Open");
        } else {
            this.textAssertions.assertTextSequence(this.locator.table(SUB_TASKS_TABLE_ID).getHTML(), "sub 1", "<img", "Resolved", "sub 2", "<img", "Open");
        }
    }

    @Test
    public void testCreateSubTaskNotVisibleWithoutPermission() {
        this.navigation.issue().viewIssue(ISSUE_PARENT);
        this.tester.assertLinkPresent("stqc_show");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.issue().viewIssue(ISSUE_PARENT);
        this.tester.assertLinkNotPresent("stqc_show");
    }
}

