/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@Restore(value="TestSubtaskSecurity.xml")
public class TestSubtaskSecurity
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.administration.attachments().enable();
    }

    @Test
    @LoginAs(user="ted")
    public void parentIssueShouldNotBeLinkedOnIssueNavigator() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertLinkPresentWithText("HSP-3");
        this.tester.assertLinkNotPresentWithText("HSP-1");
    }

    @Test
    @LoginAs(user="ted")
    public void parentIssueShouldNotBeLinkedOnManageAttachmentsPage() {
        this.navigation.issue().attachments("HSP-3").manage();
        this.tester.assertTextPresent("<li>HSP-1</li>");
        this.tester.assertLinkNotPresent("parent_issue_summary");
        this.tester.assertLinkNotPresentWithText("HSP-1");
    }

    @Test
    @LoginAs(user="bill")
    public void parentIssueShouldBeLinkedOnIssueNavigator() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertLinkPresentWithText("HSP-1");
    }

    @Test
    @LoginAs(user="bill")
    public void parentIssueShouldBeLinkedOnManageAttachmentsPage() {
        this.navigation.issue().attachments("HSP-2").manage();
        this.tester.assertTextNotPresent("<li>HSP-1</li>");
        this.tester.assertLinkPresent("parent_issue_summary");
        this.tester.assertLinkPresentWithText("HSP-1");
    }

    @Test
    @LoginAs(user="bill")
    public void parentIssueShouldBeLinkedOnViewIssuePage() {
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.assertLinkPresent("parent_issue_summary");
        this.tester.assertLinkPresentWithText("HSP-1");
    }

    @Test
    @LoginAs(user="bill")
    public void parentIssueShouldBeLinkedOnVersions() {
        this.navigation.gotoPage("browse/HSP/fixforversion/10000");
        this.tester.assertLinkPresentWithText("HSP-1");
    }

    @Test
    @LoginAs(user="bill")
    public void parentIssueShouldBeLinkedOnComponents() {
        this.navigation.gotoPage("issues/?jql=project+%3D+HSP+AND+component+%3D+%22New+Component+1%22");
        this.tester.assertLinkPresentWithText("HSP-1");
    }

    @Test
    @LoginAs(user="ted")
    public void parentIssueShouldNotBeLinkedOnVersions() {
        this.navigation.gotoPage("browse/HSP/fixforversion/10000");
        this.tester.assertLinkNotPresentWithText("HSP-1");
    }

    @Test
    @LoginAs(user="ted")
    public void parentIssueShouldNotBeLinkedOnComponents() {
        this.navigation.gotoPage("issues/?jql=project+%3D+HSP+AND+component+%3D+%22New+Component+1%22");
        this.tester.assertLinkNotPresentWithText("HSP-1");
    }
}

