/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask.move;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.google.common.collect.Sets;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
@LoginAs(user="admin")
@Restore(value="TestMoveSubTaskEnterprise.xml")
public class TestMoveSubTaskEnterprise
extends EmailBaseFuncTestCase {
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.backdoor.generalConfiguration().setContactAdminFormOn();
    }

    @Test
    public void testMoveSubtaskToParentWithNoSecurityLevel() throws SAXException {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issue().viewIssue("COW-36");
        this.tester.assertTextPresent("MyFriendsOnly");
        this.tester.clickLink("move-subtask");
        this.tester.assertTextPresent("Move Sub-Task: Choose Operation");
        this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Move Sub-Task: COW-36");
        this.tester.setFormElement("parentIssue", "COW-39");
        this.tester.submit("Change Parent");
        this.tester.assertTextNotPresent("MyFriendsOnly");
        this.navigation.issue().returnToSearch();
        this.tester.assertTextPresent("Issue Navigator");
        WebTable issueTable = this.getIssueTable();
        Assert.assertEquals((Object)"COW-36", (Object)issueTable.getCellAsText(7, 1).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(7, 11).trim());
        this.navigation.issue().gotoIssue("COW-36");
        this.tester.clickLink("changehistory-tabpanel-link");
        this.assertions.assertNewestChangeHistoryRecord("COW-36", "admin", Arrays.asList(new ExpectedChangeHistoryItem("Parent Issue", "COW-35", "COW-39"), new ExpectedChangeHistoryItem("security", "MyFriendsOnly", null)));
    }

    @Test
    public void testMoveSubtaskToParentWithSecurityLevel() throws SAXException {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issue().viewIssue("COW-36");
        this.tester.assertTextPresent("MyFriendsOnly");
        this.tester.clickLink("move-subtask");
        this.tester.assertTextPresent("Move Sub-Task: Choose Operation");
        this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Move Sub-Task: COW-36");
        this.tester.setFormElement("parentIssue", "COW-38");
        this.tester.submit("Change Parent");
        this.tester.assertTextNotPresent("MyFriendsOnly");
        IdLocator locator = new IdLocator(this.tester, "security-val");
        this.assertions.getTextAssertions().assertTextPresent(locator, "A");
        this.navigation.issue().returnToSearch();
        this.tester.assertTextPresent("Issue Navigator");
        WebTable issueTable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 1, "COW-36");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 11, "A");
        this.navigation.issue().gotoIssue("COW-36");
        this.tester.clickLink("changehistory-tabpanel-link");
        this.assertions.assertNewestChangeHistoryRecord("COW-36", "admin", Arrays.asList(new ExpectedChangeHistoryItem("Parent Issue", "COW-35", "COW-38"), new ExpectedChangeHistoryItem("security", "MyFriendsOnly", "A")));
    }

    @Test
    public void testNotifications() throws InterruptedException, MessagingException, IOException {
        this.configureAndStartSmtpServerWithNotify();
        this.backdoor.userProfile().changeUserNotificationType("admin", "text");
        this.backdoor.userProfile().changeUserNotificationType("henry.ford", "text");
        this.administration.generalConfiguration().fixBaseUrl();
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issue().viewIssue("COW-36");
        this.tester.clickLink("move-subtask");
        this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.tester.submit("Next >>");
        this.tester.setFormElement("parentIssue", "COW-38");
        this.tester.submit("Change Parent");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        HashSet expectedList = Sets.newHashSet((Object[])new String[]{"admin@example.com", "Henry.Ford@example.com"});
        HashSet receivedList = Sets.newHashSet((Object[])new String[]{mimeMessages[0].getHeader("To")[0], mimeMessages[1].getHeader("To")[0]});
        Assert.assertEquals((Object)expectedList, (Object)receivedList);
        this.assertMailProperties(mimeMessages[0]);
        this.assertMailProperties(mimeMessages[1]);
    }

    private void assertMailProperties(MimeMessage mimeMessage) throws MessagingException, IOException {
        Assert.assertEquals((Object)"[JIRATEST] (COW-36) Get another milk bucket", (Object)mimeMessage.getHeader("Subject")[0]);
        String expectedSender = this.backdoor.applicationProperties().getString("jira.email.fromheader.format").replace("${fullname}", "Mark");
        Assert.assertEquals((Object)("\"" + expectedSender + "\" <jiratest@atlassian.com>"), (Object)mimeMessage.getHeader("From")[0]);
        String body = GreenMailUtil.getBody((Part)mimeMessage);
        String baseUrl = this.getEnvironmentData().getBaseUrl().toString();
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        LinkedList<String> testStrings = new LinkedList<String>();
        testStrings.add("[ " + baseUrl + "browse/COW-36?page=com.atlassian.jira.plugin.system.issuetabpanels:all-tabpanel ]");
        testStrings.add("Mark updated COW-36:");
        testStrings.add("--------------------");
        testStrings.add("> Get another milk bucket");
        testStrings.add("> -----------------------");
        testStrings.add("Key: COW-36");
        testStrings.add("URL: " + baseUrl + "browse/COW-36");
        testStrings.add("Project: Bovine");
        testStrings.add("Issue Type: Sub-task");
        testStrings.add("Security Level: A(A)");
        testStrings.add("Reporter: Mark");
        testStrings.add("Assignee: Henry Ford");
        testStrings.add("This message was sent by Atlassian Jira");
        this.assertTextSequence(testStrings, body);
        Assert.assertTrue((boolean)body.contains("Parent Issue: COW-38  (was: COW-35)"));
        Assert.assertTrue((boolean)body.contains("Security: A  (was: MyFriendsOnly)"));
    }

    private String assertTextSequence(List<String> testStrings, String body) {
        for (String test : testStrings) {
            int index = body.indexOf(test);
            if (index < 0) {
                Assert.fail((String)("Unable to find string '" + test + "' in the body of the e-mail message."));
            }
            body = body.substring(index + test.length());
        }
        return body;
    }

    private WebTable getIssueTable() throws SAXException {
        return this.tester.getDialog().getResponse().getTableWithID("issuetable");
    }
}

