/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.permission.ProjectPermissions;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING, Category.WORKLOGS})
@LoginAs(user="admin")
@Restore(value="TestLogWork.xml")
public class TestCreateWorklog
extends BaseJiraFuncTest {
    private static final String HSP_1 = "HSP-1";
    private static final String WORK_LOG_COMMENT_1 = "This is a comment generated for a first work log.";
    private static final String WORK_LOG_COMMENT_2 = "This is a comment generated for a second work log.";
    private static final String ROLE_DEVELOPERS = "Developers";
    private static final String GROUP_ADMINISTRATORS = "jira-administrators";
    private String timeFormat;
    @Inject
    private Parser parse;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private EnvironmentUtils environmentUtils;

    @Before
    public void setUp() {
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.GROUPS_PROJECT_ROLES);
    }

    @Test
    public void testWorklogNoPermToCreate() {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.WORK_ON_ISSUES, "jira-developers");
        this.tester.gotoPage("/secure/CreateWorklog!default.jspa?id=10000");
        this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform");
    }

    @Test
    public void testLogWorkNoteCorrect() {
        this.tester.gotoPage("/secure/ShowTimeTrackingHelp.jspa?decorator=popup#LogWork");
        this.textAssertions.assertTextPresent("Your current conversion rates are 1w = 7d and 1d = 24h.");
        this.administration.timeTracking().disable();
        this.navigation.gotoAdminSection(Navigation.AdminSection.TIMETRACKING);
        this.tester.setFormElement("hoursPerDay", "6");
        this.tester.setFormElement("daysPerWeek", "5");
        this.tester.submit("Activate");
        this.tester.gotoPage("/secure/ShowTimeTrackingHelp.jspa?decorator=popup#LogWork");
        this.textAssertions.assertTextPresent("Your current conversion rates are 1w = 5d and 1d = 6h.");
    }

    @Test
    public void testMandatoryFields() {
        this.navigation.issue().viewIssue(HSP_1);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", "");
        this.tester.setFormElement("startDate", "");
        this.tester.setFormElement("newEstimate", "");
        this.tester.checkCheckbox("adjustEstimate", "new");
        this.tester.submit();
        this.textAssertions.assertTextPresent("You must indicate the time spent working.");
        this.textAssertions.assertTextPresent("You must specify a date on which the work occurred.");
        this.textAssertions.assertTextPresent("You must supply a valid new estimate.");
    }

    @Test
    public void testInvalidFormattedDurationFields() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "16 Candles");
        this.getTester().setFormElement("startDate", "18/Jun/07 10:49 AM");
        this.getTester().setFormElement("newEstimate", "Six Days, Seven Nights");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().submit();
        this.textAssertions.assertTextPresent("Invalid time duration entered.");
        this.textAssertions.assertTextPresent("Invalid new estimate entered.");
    }

    @Test
    public void testNegativeDuration() {
        this.navigation.issue().logWork(HSP_1, "-2h");
        this.textAssertions.assertTextPresent("Invalid time duration entered.");
    }

    @Test
    public void testBadFractionDuration() {
        String[] badDurations;
        for (String badDuration : badDurations = new String[]{"5.3756h"}) {
            this.navigation.issue().logWork(HSP_1, badDuration);
            this.textAssertions.assertTextPresent("Invalid time duration entered.");
        }
    }

    @Test
    public void testGoodFractionDuration() throws Exception {
        this.navigation.issue().logWork(HSP_1, "2.5h");
        this.assertTextSequence(new String[]{"Time Spent", "2 hours, 30 minutes"});
        this.navigation.issue().logWork(HSP_1, "2.5h 30m");
        this.assertTextSequence(new String[]{"Time Spent", "5 hours, 30 minutes"});
        this.navigation.issue().logWork(HSP_1, "1.5d");
        this.assertTextSequence(new String[]{"Time Spent", "1 day, 17 hours, 30 minutes"});
    }

    @Test
    public void testInvalidTimeSpentZero() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "0");
        this.getTester().setFormElement("startDate", "18/Jun/07 10:49 AM");
        this.getTester().submit();
        this.textAssertions.assertTextPresent("Time Spent can not be zero.");
    }

    @Test
    public void testInvalidStartDateField() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "4h");
        this.getTester().setFormElement("startDate", "The Day After Tomorrow");
        this.getTester().checkCheckbox("adjustEstimate", "leave");
        this.getTester().submit();
        this.textAssertions.assertTextPresent("You must specify a date on which the work occurred.");
    }

    @Test
    public void testAutoAdjustEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("edit-issue");
        this.getTester().setFormElement("timetracking", "4d");
        this.getTester().submit("Update");
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "4h 30m");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"Original Estimate", "4 days", "Remaining Estimate", "3 days, 19 hours, 30 minutes", "Time Spent", "4 hours, 30 minutes"});
    }

    @Test
    public void testNewEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("edit-issue");
        this.getTester().setFormElement("timetracking", "4d");
        this.getTester().submit("Update");
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "4h 30m");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "1d 5h");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"Original Estimate", "4 days", "Remaining Estimate", "1 day, 5 hours", "Time Spent", "4 hours, 30 minutes"});
    }

    @Test
    public void testLeaveExistingEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("edit-issue");
        this.getTester().setFormElement("timetracking", "4d");
        this.getTester().submit("Update");
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "4h 30m");
        this.getTester().checkCheckbox("adjustEstimate", "leave");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"Original Estimate", "4 days", "Remaining Estimate", "4 days", "Time Spent", "4 hours, 30 minutes"});
    }

    @Test
    public void testLogWorkVisibleToAll() {
        this.reconfigureTimetracking("pretty");
        this.execLogWorkVisibleToAll();
    }

    @Test
    public void testLogWorkVisibleToAllDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execLogWorkVisibleToAll();
    }

    @Test
    public void testLogWorkVisibleToAllHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execLogWorkVisibleToAll();
    }

    private void execLogWorkVisibleToAll() {
        this.navigation.issue().viewIssue(HSP_1);
        this.logWorkWithComment(HSP_1, "2d", WORK_LOG_COMMENT_1);
        this.getTester().clickLinkWithText("Work Log");
        this.textAssertions.assertTextPresent(WORK_LOG_COMMENT_1);
        if ("pretty".equals(this.timeFormat)) {
            this.textAssertions.assertTextPresent("2 days");
        } else if ("days".equals(this.timeFormat)) {
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Time Spent", "2d");
        } else if ("hours".equals(this.timeFormat)) {
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Time Spent", "48h");
        }
    }

    private void logWorkWithComment(String issueKey, String timeLogged, String comment) {
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", timeLogged);
        this.tester.setFormElement("comment", comment);
        this.tester.submit("Log");
    }

    @Test
    public void testLogWorkVisibleToRole() {
        this.reconfigureTimetracking("pretty");
        this.execLogWorkVisible(ROLE_DEVELOPERS);
    }

    @Test
    public void testLogWorkVisibleToRoleDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execLogWorkVisible(ROLE_DEVELOPERS);
    }

    @Test
    public void testLogWorkVisibleToRoleHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execLogWorkVisible(ROLE_DEVELOPERS);
    }

    private void assertAdminCannotSeeWorklog() {
        this.getTester().clickLinkWithText("Work Log");
        this.textAssertions.assertTextPresent(WORK_LOG_COMMENT_1);
        this.textAssertions.assertTextPresent(WORK_LOG_COMMENT_2);
        if ("pretty".equals(this.timeFormat)) {
            this.textAssertions.assertTextPresent("2 days");
            this.textAssertions.assertTextPresent("3 days");
            this.textAssertions.assertTextPresent("5 days");
        } else if ("days".equals(this.timeFormat)) {
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Time Spent", "2d");
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Time Spent", "3d");
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Time Spent", "5d");
        } else if ("hours".equals(this.timeFormat)) {
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Time Spent", "48h");
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Time Spent", "72h");
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Time Spent", "120h");
        }
    }

    private void assertFredCannotSeeWorkLog() {
        this.navigation.login("fred", "fred");
        this.navigation.issue().viewIssue(HSP_1);
        this.textAssertions.assertTextNotPresent(WORK_LOG_COMMENT_1);
        this.textAssertions.assertTextNotPresent(WORK_LOG_COMMENT_2);
        if ("pretty".equals(this.timeFormat)) {
            this.textAssertions.assertTextNotPresent("2 days");
            this.textAssertions.assertTextNotPresent("3 days");
            this.textAssertions.assertTextPresent("5 days");
        } else if ("days".equals(this.timeFormat)) {
            this.textAssertions.assertTextNotPresent(" 2d ");
            this.textAssertions.assertTextNotPresent(" 3d ");
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Time Spent", "5d");
        } else if ("hours".equals(this.timeFormat)) {
            this.textAssertions.assertTextNotPresent(" 48h ");
            this.textAssertions.assertTextNotPresent(" 72h ");
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Time Spent", "120h");
        }
    }

    @Test
    public void testLogWorkVisibleToGroup() {
        this.reconfigureTimetracking("pretty");
        this.execLogWorkVisible(GROUP_ADMINISTRATORS);
    }

    @Test
    public void testLogWorkVisibleToGroupDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execLogWorkVisible(GROUP_ADMINISTRATORS);
    }

    @Test
    public void testLogWorkVisibleToGroupHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execLogWorkVisible(GROUP_ADMINISTRATORS);
    }

    @Test
    public void testLogWorkDateIsStartDate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "2d");
        this.getTester().setFormElement("startDate", "1/Jun/06 12:00 PM");
        this.getTester().submit();
        this.getTester().clickLinkWithText("Work Log");
        this.textAssertions.assertTextPresent("01/Jun/06 12:00 PM");
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "2d");
        this.getTester().setFormElement("startDate", "1/Jun/05 12:00 PM");
        this.getTester().submit();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "1/Jun/06 12:00 PM", "01/Jun/05 12:00 PM");
    }

    private void execLogWorkVisible(String level) {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "2d");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "2w");
        this.getTester().setFormElement("comment", WORK_LOG_COMMENT_1);
        this.getTester().selectOption("commentLevel", level);
        this.getTester().submit();
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "3d");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "2w");
        this.getTester().setFormElement("comment", WORK_LOG_COMMENT_2);
        this.getTester().selectOption("commentLevel", level);
        this.getTester().submit();
        this.assertAdminCannotSeeWorklog();
        this.assertFredCannotSeeWorkLog();
    }

    private void reconfigureTimetracking(String format) {
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        this.tester.submit("Deactivate");
        this.tester.checkCheckbox("timeTrackingFormat", format);
        this.tester.submit("Activate");
        this.timeFormat = format;
    }

    @Test
    public void testChangeHistory() throws Exception {
        boolean isOracle = this.environmentUtils.isOracle();
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("edit-issue");
        this.getTester().setFormElement("timetracking", "4d");
        this.getTester().submit("Update");
        if (isOracle) {
            Thread.sleep(2000L);
        }
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "4h 30m");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "1d 5h");
        this.getTester().submit("Log");
        this.getTester().clickLinkWithText("History");
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Administrator").add("Original Estimate", "4 days [ 345600 ]").add("Remaining Estimate", "4 days [ 345600 ]");
        expectedList.addChangeSet("Administrator").add("Time Spent", "4 hours, 30 minutes [ 16200 ]").add("Remaining Estimate", "1 day, 5 hours [ 104400 ]");
        ChangeHistoryList list = this.parse.issue().parseChangeHistory();
        list.assertContainsSomeOf(expectedList);
    }

    @Test
    public void testManuallyReduceEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("timetracking", "2d");
        this.tester.submit("Update");
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", "12h");
        this.tester.checkCheckbox("adjustEstimate", "manual");
        this.tester.setWorkingForm("log-work");
        this.tester.submit();
        this.textAssertions.assertTextPresent("You must supply a valid amount of time to adjust the estimate by.");
        this.tester.setFormElement("adjustmentAmount", "1cow");
        this.tester.setWorkingForm("log-work");
        this.tester.submit();
        this.textAssertions.assertTextPresent("Invalid time entered for adjusting the estimate.");
        this.tester.setFormElement("adjustmentAmount", "6h");
        this.tester.setWorkingForm("log-work");
        this.tester.submit();
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated:", "2d", "Remaining:", "1d 18h", "Logged:", "12h");
    }

    private void assertTextSequence(String[] strings) {
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
    }
}

