/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.matchers.SearchResultMatchers;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.util.SearchResultMatcher;
import com.atlassian.jira.webtests.ztests.timetracking.modern.AbstractWorklogSearchingTest;
import io.atlassian.fugue.Effect;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.WORKLOGS})
public final class TestWorklogCommentSearching
extends AbstractWorklogSearchingTest {
    @Inject
    private Navigation navigation;
    @Inject
    private EnvironmentUtils environmentUtils;

    @Before
    public void setUp() {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_OWN_WORKLOGS, "jira-users");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.DELETE_OWN_WORKLOGS, "jira-users");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
    }

    @Test
    public void testEqualsOneCommentOperator() throws Exception {
        String issueKey1 = this.createDefaultIssue();
        String issueKey2 = this.createDefaultIssue();
        this.createWorklogAsUserWithComment(issueKey1, "admin", "I worked hard");
        this.createWorklogAsUserWithComment(issueKey2, "fred", "MyExactComment");
        SearchResult searchResult = this.executeJqlSearch("worklogComment ~ MyExactComment");
        Assert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        Assert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueKey2));
    }

    @Test
    public void testEmptyCommentOperator() throws Exception {
        this.navigation.login("admin", "admin");
        Assume.assumeFalse((boolean)this.environmentUtils.isOracle());
        String issueKey1 = this.createDefaultIssue();
        String issueKey2 = this.createDefaultIssue();
        this.createWorklogAsUserWithComment(issueKey1, "admin", "I worked hard");
        this.createWorklogAsUserWithComment(issueKey2, "fred", "");
        SearchResult searchResult = this.executeJqlSearch("worklogComment is empty");
        Assert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        Assert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueKey2));
    }

    @Test
    public void testNotEqualsCommentOperator() throws Exception {
        String issueKey1 = this.createDefaultIssue();
        String issueKey2 = this.createDefaultIssue();
        this.createWorklogAsUserWithComment(issueKey1, "admin", "I worked hard");
        this.createWorklogAsUserWithComment(issueKey2, "fred", "MyExactComment");
        SearchResult searchResult = this.executeJqlSearch("worklogComment !~ MyExactComment");
        Assert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        Assert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueKey1));
    }

    @Test
    public void testEqualsTwoCommentsOperator() throws Exception {
        String issueKey1 = this.createDefaultIssue();
        String issueKey2 = this.createDefaultIssue();
        this.createWorklogAsUserWithComment(issueKey1, "admin", "MyExactComment alpha");
        this.createWorklogAsUserWithComment(issueKey2, "fred", "MyExactComment beta");
        SearchResult searchResult = this.executeJqlSearch("worklogComment ~ MyExactComment");
        Assert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(2));
        Assert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueKey1, issueKey2));
    }

    @Test
    public void testDeleteCommentReindexesIssue() {
        String issueKey1 = this.createDefaultIssue();
        Worklog worklog = this.createWorklogAsUserWithComment(issueKey1, "admin", "I worked hard");
        SearchResult searchResult = this.executeJqlSearch("worklogComment ~ worked");
        Assert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        Assert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueKey1));
        this.deleteWorklog(issueKey1, worklog);
        searchResult = this.executeJqlSearch("worklogComment ~ worked");
        Assert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(0));
    }

    @Test
    public void testUpdateCommentReindexesIssue() {
        String issueKey1 = this.createDefaultIssue();
        Worklog worklog = this.createWorklogAsUserWithComment(issueKey1, "admin", "I worked hard");
        SearchResult searchResult = this.executeJqlSearch("worklogComment ~ worked");
        Assert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        Assert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueKey1));
        worklog.comment = "newComment";
        worklog.timeSpentSeconds = null;
        this.updateWorklog(issueKey1, worklog);
        searchResult = this.executeJqlSearch("worklogComment ~ worked");
        Assert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(0));
        searchResult = this.executeJqlSearch("worklogComment ~ newComment");
        Assert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
    }

    @Test
    public void testSearchingWorklogInDeletedIssue() throws Exception {
        String issueKey = this.createDefaultIssue();
        this.createWorklogAsUserWithComment(issueKey, "admin", "I worked on an issue that will be deleted");
        MatcherAssert.assertThat((Object)this.executeJqlSearch("worklogComment ~ deleted"), SearchResultMatchers.sizeEquals(1));
        this.issueClient.delete(issueKey, null);
        MatcherAssert.assertThat((Object)this.executeJqlSearch("worklogComment ~ deleted"), SearchResultMatchers.sizeEquals(0));
    }

    @Test
    public void testAuthorAndDateConditionSimple() throws Exception {
        String issue = this.createDefaultIssue();
        this.createWorklog(issue, "2014-08-10", "admin", "comment1");
        this.createWorklog(issue, "2014-08-13", "fred", "comment2");
        SearchResult searchResult = this.executeJqlSearch("worklogDate = 2014-08-10 AND worklogAuthor = admin AND worklogComment ~ comment1");
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatcher.issues(issue));
        searchResult = this.executeJqlSearch("worklogDate = 2014-08-10 AND worklogComment ~ comment2");
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(0));
        searchResult = this.executeJqlSearch("worklogAuthor = fred AND worklogComment ~ comment1");
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(0));
    }

    @Test
    public void testOrConditions() throws Exception {
        final String issueWithWorklogsOn10thAnd13th = this.createDefaultIssue();
        this.createWorklog(issueWithWorklogsOn10thAnd13th, "2014-08-10", "admin", "comment1");
        this.createWorklog(issueWithWorklogsOn10thAnd13th, "2014-08-13", "admin", "comment2");
        final String issueWithWorklogOn9thAnd14th = this.createDefaultIssue();
        this.createWorklog(issueWithWorklogOn9thAnd14th, "2014-08-09", "fred", "comment3");
        this.createWorklog(issueWithWorklogOn9thAnd14th, "2014-08-14", "fred", "comment4");
        Effect<String> testBothIssuesReturnedForQuery = new Effect<String>(){

            public void apply(String query) {
                SearchResult searchResult = TestWorklogCommentSearching.this.executeJqlSearchAsUser(query, "admin");
                MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(2));
                MatcherAssert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueWithWorklogsOn10thAnd13th, issueWithWorklogOn9thAnd14th));
            }
        };
        testBothIssuesReturnedForQuery.apply((Object)"worklogComment ~ comment1 or worklogComment ~ comment3");
        testBothIssuesReturnedForQuery.apply((Object)"worklogDate = 2014-08-10 OR worklogComment ~ comment4");
        testBothIssuesReturnedForQuery.apply((Object)"worklogAuthor = admin OR worklogComment ~ comment3");
        testBothIssuesReturnedForQuery.apply((Object)"worklogAuthor = admin AND worklogComment ~ comment1 OR worklogAuthor = fred AND worklogComment ~ comment3");
    }

    @Test
    public void testSimpleTextSearchingInDescriptionAndWorklog() throws Exception {
        this.testSimpleTextSearchingInDescriptionAndWorklogWithText("bears");
    }

    @Test
    public void testSimpleTextSearchingComplexTextInDescriptionAndWorklog() throws Exception {
        this.testSimpleTextSearchingInDescriptionAndWorklogWithText("white bears");
    }

    @Test
    public void worklogsThatAreOverTheIndexingLimitAreNotReturnedInSearch() {
        this.backdoor.systemProperties().setProperty("jira.safeguards.indexing.issue.worklogs", "5");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "someIssue");
        List<String> worklogs = IntStream.range(0, 10).mapToObj(number -> "worklog" + number).collect(Collectors.toList());
        worklogs.forEach(worklog -> this.createWorklog(issue.key, "1975-05-25", "admin", (String)worklog));
        this.backdoor.indexing().reindexAll();
        worklogs.stream().limit(5L).forEach(worklog -> {
            SearchResult searchResult = this.backdoor.search().getSearch(new SearchRequest().jql(String.format("project = %s AND worklogComment ~ %s", "HSP", worklog)));
            MatcherAssert.assertThat((Object)searchResult.issues, (Matcher)IsCollectionWithSize.hasSize((int)0));
        });
        worklogs.stream().skip(5L).forEach(worklog -> {
            SearchResult searchResult = this.backdoor.search().getSearch(new SearchRequest().jql(String.format("project = %s AND worklogComment ~ %s", "HSP", worklog)));
            MatcherAssert.assertThat((Object)searchResult.issues, (Matcher)IsCollectionWithSize.hasSize((int)1));
            MatcherAssert.assertThat((Object)((Issue)searchResult.issues.get((int)0)).key, (Matcher)Is.is((Object)issue.key));
        });
        this.backdoor.systemProperties().unsetProperty("jira.safeguards.indexing.issue.worklogs");
    }

    private void testSimpleTextSearchingInDescriptionAndWorklogWithText(String toSearch) {
        String issueWithSummary = this.backdoor.issues().createIssue((String)"HSP", (String)new StringBuilder().append((String)"test issue! ").append((String)toSearch).toString(), (String)"admin").key;
        String issueOther = this.backdoor.issues().createIssue((String)"HSP", (String)"some other issue ", (String)"admin").key;
        String issueOtherAuthor = this.backdoor.issues().createIssue((String)"HSP", (String)"some other issue ", (String)"fred").key;
        String issueWithWorklog = this.createDefaultIssue();
        this.createWorklog(issueWithWorklog, "2014-08-13", "admin", toSearch + " comment");
        this.createWorklog(issueWithWorklog, "2014-08-13", "admin", "some other admin worklog");
        this.createWorklog(issueWithWorklog, "2014-08-09", "fred", "comment " + toSearch);
        SearchResult searchResult = this.executeJqlSearch(String.format("worklogAuthor = admin", toSearch));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        searchResult = this.executeJqlSearch(String.format("text ~ '%s'", toSearch));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(2));
        searchResult = this.executeJqlSearch(String.format("worklogAuthor = admin AND text ~ '%s'", toSearch));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
    }
}

