/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.matchers.SearchResultMatchers;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.util.SearchResultMatcher;
import com.atlassian.jira.webtests.ztests.timetracking.modern.AbstractWorklogSearchingTest;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.WORKLOGS})
public class TestWorklogDateSearching
extends AbstractWorklogSearchingTest {
    @Before
    public void setUp() {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_OWN_WORKLOGS, "jira-users");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.DELETE_OWN_WORKLOGS, "jira-users");
    }

    @Test
    public void testEqualOperators() throws Exception {
        String secondStartDate = "2014-08-11";
        String otherStartDate = "2014-08-14";
        String issueKey1 = this.createDefaultIssue();
        String issueKey2 = this.createDefaultIssue();
        this.createWorklog(issueKey1, "2014-08-06");
        this.createWorklog(issueKey2, "2014-08-11");
        SearchResult result = this.executeJqlSearch("worklogDate = 2014-08-06");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        String query = "worklogDate in (2014-08-06, 2014-08-11, 2014-08-14)";
        result = this.executeJqlSearch(query);
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(2));
    }

    @Test
    public void testGreaterThanOperator() throws Exception {
        String startDate = "2014-08-10";
        String lowerStartDate = "2014-08-09";
        String issueKey = this.createDefaultIssue();
        this.createWorklog(issueKey, "2014-08-10");
        SearchResult result = this.executeJqlSearch("worklogDate > 2014-08-10");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(0));
        result = this.executeJqlSearch("worklogDate > 2014-08-09");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
    }

    @Test
    public void testGreaterThenOrEqualsOperator() {
        String startDate = "2014-08-10";
        String upperStartDate = "2014-08-11";
        String issueKey = this.createDefaultIssue();
        this.createWorklog(issueKey, "2014-08-10");
        SearchResult result = this.executeJqlSearch("worklogDate >= 2014-08-10");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        result = this.executeJqlSearch("worklogDate >= 2014-08-11");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(0));
    }

    @Test
    public void testLessThenOperator() {
        String startDate = "2014-08-10";
        String upperStartDate = "2014-08-11";
        String issueKey = this.createDefaultIssue();
        this.createWorklog(issueKey, "2014-08-10");
        SearchResult result = this.executeJqlSearch("worklogDate < 2014-08-10");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(0));
        result = this.executeJqlSearch("worklogDate < 2014-08-11");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueKey));
    }

    @Test
    public void testLessThenOrEquals() {
        String startDate = "2014-08-10";
        String lowerStartDate = "2014-08-09";
        String issueKey = this.createDefaultIssue();
        this.createWorklog(issueKey, "2014-08-10");
        SearchResult result = this.executeJqlSearch("worklogDate <= 2014-08-10");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        result = this.executeJqlSearch("worklogDate <= 2014-08-09");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(0));
    }

    @Test
    public void testWhetherConditionsAreSatisfiedForSingleWorklog() throws Exception {
        String issueWithWorklogOn10th = this.createDefaultIssue();
        this.createWorklog(issueWithWorklogOn10th, "2014-08-10");
        String issueWithWorklogOn13th = this.createDefaultIssue();
        this.createWorklog(issueWithWorklogOn13th, "2014-08-13");
        SearchResult result = this.executeJqlSearch("worklogDate > 2014-08-11 AND worklogDate < 2014-08-12");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(0));
        result = this.executeJqlSearch("worklogDate > 2014-08-14 AND worklogDate < 2014-08-09");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(0));
        result = this.executeJqlSearch("worklogDate > 2014-08-09 AND worklogDate < 2014-08-11");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueWithWorklogOn10th));
        result = this.executeJqlSearch("worklogDate > 2014-08-12 AND worklogDate < 2014-08-14");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueWithWorklogOn13th));
        result = this.executeJqlSearch("worklogDate > 2014-08-09 AND worklogDate < 2014-08-14");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(2));
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueWithWorklogOn10th, issueWithWorklogOn13th));
    }

    @Test
    public void testWorklogServedAsString() throws Exception {
        String startDate = "2014-08-10";
        String issueKey = this.createDefaultIssue();
        this.createWorklog(issueKey, "2014-08-10");
        SearchResult result = this.executeJqlSearch("worklogDate = 2014-08-10");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueKey));
    }

    @Test
    public void testWorklogServedAsJql() throws Exception {
        String issueKey = this.createDefaultIssue();
        Worklog worklog = new Worklog();
        worklog.started = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
        worklog.timeSpent = "1h";
        this.worklogClient.post(issueKey, worklog);
        SearchResult result = this.executeJqlSearch("worklogDate = now()");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueKey));
    }

    @Test
    public void testDuplicatedRelationalOperators() throws Exception {
        String issueCreatedOn11th = this.createDefaultIssue();
        this.createWorklog(issueCreatedOn11th, "2014-08-11");
        String issueCreatedOn10th = this.createDefaultIssue();
        this.createWorklog(issueCreatedOn10th, "2014-08-10");
        String issueCreatedOn13th = this.createDefaultIssue();
        this.createWorklog(issueCreatedOn13th, "2014-08-13");
        SearchResult result = this.executeJqlSearch("worklogDate > 2014-08-09 AND worklogDate > 2014-08-10");
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueCreatedOn11th, issueCreatedOn13th));
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(2));
        result = this.executeJqlSearch("worklogDate > 2014-08-10 AND worklogDate > 2014-08-12");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueCreatedOn13th));
        result = this.executeJqlSearch("worklogDate < 2014-08-13 AND worklogDate < 2014-08-12");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(2));
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueCreatedOn10th, issueCreatedOn11th));
        result = this.executeJqlSearch("worklogDate > 2014-08-09 AND worklogDate > 2014-08-10\n AND worklogDate < 2014-08-13 and worklogDate < 2014-08-12");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueCreatedOn11th));
    }

    @Test
    public void testComplexQuery() throws Exception {
        String reporter = "admin";
        String projectKey1 = "HSP";
        String projectKey2 = "MKY";
        String startDate = "2014-08-10";
        String upperStartDate = "2014-08-11";
        String lowerStartDate = "2014-08-09";
        String issueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"test issue!", (String)"admin").key;
        this.backdoor.issues().createIssue("MKY", "test issue!", "admin");
        this.createWorklog(issueKey, "2014-08-10");
        String rangeQuery = "(worklogDate > 2014-08-09 AND worklogDate < 2014-08-11)";
        String falseQuery = "worklogDate > 2222-08-10";
        String compoundQuery = "(reporter = admin and (worklogDate > 2014-08-09 AND worklogDate < 2014-08-11))";
        String project2Query = "project = MKY";
        SearchResult result = this.executeJqlSearch("(worklogDate > 2014-08-09 AND worklogDate < 2014-08-11) and worklogDate > 2222-08-10 and (reporter = admin and (worklogDate > 2014-08-09 AND worklogDate < 2014-08-11))");
        MatcherAssert.assertThat((Object)result.total, (Matcher)Matchers.equalTo((Object)0));
        result = this.executeJqlSearch("(worklogDate > 2014-08-09 AND worklogDate < 2014-08-11) or worklogDate > 2222-08-10 and (reporter = admin and (worklogDate > 2014-08-09 AND worklogDate < 2014-08-11))");
        MatcherAssert.assertThat((Object)result.total, (Matcher)Matchers.equalTo((Object)1));
        result = this.executeJqlSearch("(worklogDate > 2014-08-09 AND worklogDate < 2014-08-11) or worklogDate > 2222-08-10 and (reporter = admin and (worklogDate > 2014-08-09 AND worklogDate < 2014-08-11)) or project = MKY");
        MatcherAssert.assertThat((Object)result.total, (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testWhenTimeTrackingIsOff() throws Exception {
        String issueKey = this.createDefaultIssue();
        this.createWorklog(issueKey, "2014-08-06");
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", false);
        int responseCode = this.getResponseCode("worklogDate=2014-08-06");
        MatcherAssert.assertThat((Object)responseCode, (Matcher)Matchers.equalTo((Object)400));
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        responseCode = this.getResponseCode("worklogDate=2014-08-06");
        MatcherAssert.assertThat((Object)responseCode, (Matcher)Matchers.equalTo((Object)200));
    }

    @Test
    public void testWhetherPermissionsToProjectAreRespected() throws Exception {
        String issueKey = this.createDefaultIssue();
        this.createWorklog(issueKey, "2014-08-06");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        int responseCode = this.getResponseCode("worklogDate=2014-08-06");
        MatcherAssert.assertThat((Object)responseCode, (Matcher)Matchers.equalTo((Object)400));
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        responseCode = this.getResponseCode("worklogDate=2014-08-06");
        MatcherAssert.assertThat((Object)responseCode, (Matcher)Matchers.equalTo((Object)200));
    }

    @Test
    public void testWhetherPermissionsToVisibleForGroupAreRespected() throws Exception {
        String currentUser = "admin";
        String groupName = "Test-Group";
        this.backdoor.usersAndGroups().addGroup("Test-Group");
        this.backdoor.usersAndGroups().addUserToGroup("admin", "Test-Group");
        String issueKey2 = this.backdoor.issues().createIssue((String)"HSP", (String)"test issue!", (String)"admin").key;
        Worklog worklog = new Worklog();
        worklog.started = this.getDateFromString("2014-08-06");
        worklog.visibility = new Visibility("group", "Test-Group");
        worklog.timeSpent = "1h";
        this.worklogClient.post(issueKey2, worklog);
        SearchResult result = this.executeEqualWorklogDateSearchAsUser("2014-08-06", "admin");
        MatcherAssert.assertThat((Object)result.total, (Matcher)Matchers.equalTo((Object)1));
        this.backdoor.usersAndGroups().removeUserFromGroup("admin", "Test-Group");
        result = this.executeEqualWorklogDateSearchAsUser("2014-08-06", "admin");
        MatcherAssert.assertThat((Object)result.total, (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testWhetherPermissionsToVisibleForRoleAreRespected() throws Exception {
        String currentUser = "admin";
        String projectKey = "HSP";
        this.backdoor.projectRole().addActors("HSP", "Users", null, new String[]{"admin"});
        String issueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"test issue!", (String)"admin").key;
        Worklog worklog = new Worklog();
        worklog.started = this.getDateFromString("2014-08-06");
        worklog.visibility = new Visibility("role", "Users");
        worklog.timeSpent = "1h";
        this.worklogClient.post(issueKey, worklog);
        SearchResult result = this.executeEqualWorklogDateSearchAsUser("2014-08-06", "admin");
        MatcherAssert.assertThat((Object)result.total, (Matcher)Matchers.equalTo((Object)1));
        this.backdoor.projectRole().deleteUser("HSP", "Users", "admin");
        result = this.executeEqualWorklogDateSearchAsUser("2014-08-06", "admin");
        MatcherAssert.assertThat((Object)result.total, (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testSearchingCreatedWorklog() throws Exception {
        String issueKey = this.createDefaultIssue();
        this.createWorklog(issueKey, "2014-08-06");
        SearchResult result = this.executeEqualWorklogDateSearch("2014-08-06");
        MatcherAssert.assertThat((Object)result.total, (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testSearchingEditedWorklog() throws Exception {
        String newStartDate = "2014-08-11";
        String issueKey = this.createDefaultIssue();
        Worklog worklog = this.createWorklog(issueKey, "2014-08-06");
        SearchResult result = this.executeEqualWorklogDateSearch("2014-08-11");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(0));
        Worklog worklogToEdit = new Worklog();
        worklogToEdit.id = worklog.id;
        worklogToEdit.started = this.getDateFromString("2014-08-11");
        this.worklogClient.put(issueKey, worklogToEdit);
        result = this.executeEqualWorklogDateSearch("2014-08-11");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
    }

    @Test
    public void testSearchingDeletedWorklog() throws Exception {
        String issueKey = this.createDefaultIssue();
        Worklog worklog = this.createWorklog(issueKey, "2014-08-06");
        SearchResult result = this.executeEqualWorklogDateSearch("2014-08-06");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        this.worklogClient.delete(issueKey, worklog);
        result = this.executeEqualWorklogDateSearch("2014-08-06");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(0));
    }

    @Test
    public void testSearchingWorklogInDeletedIssue() throws Exception {
        String issueKey = this.createDefaultIssue();
        this.createWorklog(issueKey, "2014-08-06");
        SearchResult result = this.executeEqualWorklogDateSearch("2014-08-06");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)result, SearchResultMatcher.issues(issueKey));
        this.issueClient.delete(issueKey, null);
        result = this.executeEqualWorklogDateSearch("2014-08-06");
        MatcherAssert.assertThat((Object)result, SearchResultMatchers.sizeEquals(0));
    }

    @Test
    public void testIssueContainsMultipleWorklogs() {
        String issueWithWorklogsOn10thAnd13th = this.createDefaultIssue();
        this.createWorklog(issueWithWorklogsOn10thAnd13th, "2014-08-10");
        this.createWorklog(issueWithWorklogsOn10thAnd13th, "2014-08-13");
        String issueWithWorklogOn9thAnd14th = this.createDefaultIssue();
        this.createWorklog(issueWithWorklogOn9thAnd14th, "2014-08-09");
        this.createWorklog(issueWithWorklogOn9thAnd14th, "2014-08-14");
        SearchResult searchResult = this.executeJqlSearch("worklogDate < 2014-08-10");
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueWithWorklogOn9thAnd14th));
        searchResult = this.executeJqlSearch("worklogDate > 2014-08-09 AND worklogDate < 2014-08-14");
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueWithWorklogsOn10thAnd13th));
        searchResult = this.executeJqlSearch("worklogDate >= 2014-08-10 AND worklogDate <= 2014-08-13");
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueWithWorklogsOn10thAnd13th));
        searchResult = this.executeJqlSearch("worklogDate = 2014-08-09 OR worklogDate = 2014-08-13");
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(2));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueWithWorklogOn9thAnd14th, issueWithWorklogsOn10thAnd13th));
        searchResult = this.executeJqlSearch("worklogDate in (\"2014-08-09\", \"2014-08-13\")");
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(2));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueWithWorklogOn9thAnd14th, issueWithWorklogsOn10thAnd13th));
        searchResult = this.executeJqlSearch("worklogDate > 2014-08-13");
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(1));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueWithWorklogOn9thAnd14th));
        searchResult = this.executeJqlSearch("worklogDate >= 2014-08-13");
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatchers.sizeEquals(2));
        MatcherAssert.assertThat((Object)searchResult, SearchResultMatcher.issues(issueWithWorklogOn9thAnd14th, issueWithWorklogsOn10thAnd13th));
    }
}

