/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.testkit.beans.DirectoryDTO;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.UsersAndGroupsControl;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.text.MessageFormat;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;

public class LdapUtil {
    private static final String USR_DIR_NAME = "LDAP Directory";
    private final WebTester tester;
    private final com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;
    private final Navigation navigation;
    private final FuncTestLogger logger;
    private final Assertions assertions;
    private final TextAssertions text;
    private final UsersAndGroupsControl usersAndGroupsControl;

    @Inject
    public LdapUtil(WebTester tester, com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData, Navigation navigation, FuncTestLogger logger, Assertions assertions, TextAssertions text) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.navigation = navigation;
        this.logger = logger;
        this.assertions = assertions;
        this.text = text;
        this.usersAndGroupsControl = new UsersAndGroupsControl((JIRAEnvironmentData)environmentData);
    }

    public void createLdapDirectory() throws InterruptedException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.tester.assertTextPresent("User Directories");
        if (!this.tester.getDialog().isTextInResponse(USR_DIR_NAME)) {
            if (this.isActiveDirectory()) {
                this.logger.log((Object)"Attempting to add an Active Directory LDAP User Directory...");
                this.addActiveDirectory();
            } else {
                this.logger.log((Object)"Attempting to add an Open LDAP User Directory...");
                this.addOpenLdap();
            }
            WebTable table = this.assertions.getTableAssertions().getWebTable("directory-list");
            this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, this.getInternalDirectoryName());
            this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 1, USR_DIR_NAME);
            WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
            WebLink link = tblDirectoryList.getTableCell(2, 3).getLinkWith("up");
            this.navigation.clickLinkWithPost(link);
            table = this.assertions.getTableAssertions().getWebTable("directory-list");
            this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, USR_DIR_NAME);
            this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 1, this.getInternalDirectoryName());
            this.synchroniseDirectory(1);
        }
    }

    public String getInternalDirectoryName() {
        return this.usersAndGroupsControl.getAllDirectories().stream().filter(directory -> directory.getType() == DirectoryType.INTERNAL).map(DirectoryDTO::getName).findFirst().orElse("");
    }

    public String getDirectoryName() {
        return USR_DIR_NAME;
    }

    private void addActiveDirectory() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", USR_DIR_NAME);
        this.tester.selectOption("type", "Microsoft Active Directory");
        this.tester.setFormElement("hostname", this.getLdapServer());
        if (!Boolean.valueOf(StringUtils.defaultString((String)this.getConfigurationOption("ldap.nossl"), (String)"false")).booleanValue()) {
            this.tester.setFormElement("port", "636");
            this.tester.checkCheckbox("useSSL", "true");
        }
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapUserObjectclass", "user");
        this.tester.setFormElement("ldapUserFilter", "(&(objectCategory=Person)(sAMAccountName=*))");
        this.tester.setFormElement("ldapUserUsername", "sAMAccountName");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "unicodePwd");
        this.tester.setFormElement("ldapGroupObjectclass", "group");
        this.tester.setFormElement("ldapGroupFilter", "(objectCategory=Group)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "member");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.setFormElement("ldapExternalId", "objectGUID");
        this.tester.setFormElement("nestedGroupsEnabled", "true");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.assertExtendedTestPageAndReturnToDirectoryList();
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent(this.getInternalDirectoryName());
        this.tester.assertTextPresent(USR_DIR_NAME);
    }

    private void addOpenLdap() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", USR_DIR_NAME);
        this.tester.selectOption("type", "OpenLDAP");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapUserObjectclass", "inetorgperson");
        this.tester.setFormElement("ldapUserFilter", "(objectclass=inetorgperson)");
        this.tester.setFormElement("ldapUserUsername", "cn");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "userPassword");
        this.tester.setFormElement("ldapGroupObjectclass", "groupOfUniqueNames");
        this.tester.setFormElement("ldapGroupFilter", "(objectclass=groupOfUniqueNames)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "uniqueMember");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.setFormElement("ldapExternalId", "entryUUID");
        this.tester.setFormElement("nestedGroupsEnabled", "true");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.assertExtendedTestPageAndReturnToDirectoryList();
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent(this.getInternalDirectoryName());
        this.tester.assertTextPresent(USR_DIR_NAME);
    }

    protected boolean isActiveDirectory() {
        String ldapType = this.getConfigurationOption("ldap.type");
        if (ldapType == null) {
            throw new IllegalStateException("Missing configuration for 'ldap.type'.");
        }
        if (ldapType.equals("ActiveDirectory")) {
            return true;
        }
        if (ldapType.equals("OpenLdap")) {
            return false;
        }
        throw new IllegalStateException("Unknown LDAP type '" + ldapType + "'");
    }

    protected String getTypeDisplayName() {
        String ldapType = this.getConfigurationOption("ldap.type");
        if (ldapType == null) {
            throw new IllegalStateException("Missing configuration for 'ldap.type'.");
        }
        if (ldapType.equals("ActiveDirectory")) {
            return "Microsoft Active Directory";
        }
        if (ldapType.equals("OpenLdap")) {
            return "OpenLDAP";
        }
        throw new IllegalStateException("Unknown LDAP type '" + ldapType + "'");
    }

    protected String getUserDn() {
        String userDn = this.getConfigurationOption("ldap.userdn");
        if (userDn == null) {
            if (this.isActiveDirectory()) {
                if (this.getLdapServer().equals("crowd-ad1.sydney.atlassian.com")) {
                    return "cn=Administrator,cn=Users,dc=sydney,dc=atlassian,dc=com";
                }
                return "cn=Administrator,cn=Users,dc=tpm,dc=atlassian,dc=com";
            }
            if (this.getLdapServer().equals("crowd-op23") || this.getLdapServer().equals("172.22.200.133")) {
                return "o=sgi,c=us";
            }
            return "cn=admin,dc=example,dc=com";
        }
        return userDn;
    }

    protected String getPassword() {
        String password = this.getConfigurationOption("ldap.password");
        if (password == null) {
            if (this.isActiveDirectory()) {
                if (this.getLdapServer().equals("crowd-ad1.sydney.atlassian.com")) {
                    return "atlassian";
                }
                return "5P3rtaaah";
            }
            return "secret";
        }
        return password;
    }

    protected String getBaseDn() {
        String baseDn = this.getConfigurationOption("ldap.basedn");
        if (baseDn == null) {
            if (this.isActiveDirectory()) {
                if (this.getLdapServer().equals("crowd-ad1.sydney.atlassian.com")) {
                    return "OU=People,dc=sydney,dc=atlassian,dc=com";
                }
                return "dc=tpm,dc=atlassian,dc=com";
            }
            if (this.getLdapServer().equals("crowd-op23") || this.getLdapServer().equals("172.22.200.133")) {
                return "ou=JIRA-TPM,o=sgi,c=us";
            }
            return "dc=example,dc=com";
        }
        return baseDn;
    }

    protected String getConfigurationOption(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        return this.environmentData.getProperty(key);
    }

    protected String getLdapServer() {
        String server = this.getConfigurationOption("ldap.server");
        if (server == null) {
            server = this.isActiveDirectory() ? "ec2-windows.tpm.atlassian.com" : "localhost";
        }
        this.logger.log((Object)MessageFormat.format("Using LDAP server: {0}", server));
        return server;
    }

    protected void assertExtendedTestPageAndReturnToDirectoryList() {
        this.tester.assertTextPresent("Test Remote Directory Connection");
        this.tester.assertTextPresent("For extended testing enter the credentials of a user in the remote directory");
        this.tester.clickLinkWithText("Back to directory list");
    }

    protected void synchroniseDirectory(int row) throws InterruptedException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        this.logger.log((Object)("Attempting to synchronise Directory " + row));
        TableCell operations = tblDirectoryList.getTableCell(row, 4);
        if (operations.asText().contains("Synchronising")) {
            this.logger.log((Object)("Directory " + row + " is already synchronising ... we will wait until it is complete."));
        } else {
            this.navigation.clickLinkWithPost(operations.getLinkWith("Synchronise"));
        }
        int attempts = 0;
        while (true) {
            Thread.sleep(100L);
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
            operations = new UserDirectoryTable(this.tester, this.logger, this.assertions).getTableCell(row, 4);
            if (!operations.asText().contains("Synchronising")) break;
            if (++attempts > 100) {
                Assert.fail((String)("Directory did not finish synchronising. Giving up after " + attempts + " retries."));
            }
            this.logger.log((Object)"Still synchronising ...");
        }
        Assert.assertNotNull((Object)operations.getLinkWith("Synchronise"));
        this.logger.log((Object)"Synchronise is finished.");
    }
}

