/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

class MockCrowdServerRule
implements TestRule {
    private static final int PORT = 44455;

    MockCrowdServerRule() {
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try (AutoCloseable ignored = MockCrowdServerRule.this.withServer();){
                    base.evaluate();
                }
            }
        };
    }

    public String url() {
        return "http://localhost:44455";
    }

    private AutoCloseable withServer() throws Exception {
        Server server = new Server(44455);
        HandlerList list = new HandlerList();
        list.addHandler((Handler)this.createContext(new UserManagment(), "/", "/rest/usermanagement/1/search"));
        server.setHandler((Handler)list);
        server.start();
        return () -> ((Server)server).stop();
    }

    private ServletContextHandler createContext(HttpServlet handler, String contextPath, String pathSpec) {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(contextPath);
        context.addServlet(new ServletHolder((Servlet)handler), pathSpec);
        return context;
    }

    private void respondWithData(HttpServletResponse response, String responseText) throws IOException {
        response.setContentType("application/xml");
        response.getWriter().write(responseText);
        response.getWriter().close();
    }

    private class UserManagment
    extends HttpServlet {
        private static final String EMBEDDED_CROWD_VERSION_NAME = "X-Embedded-Crowd-Version";
        private static final String RANDOM_VERSION = "1";

        private UserManagment() {
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setHeader(EMBEDDED_CROWD_VERSION_NAME, RANDOM_VERSION);
            MockCrowdServerRule.this.respondWithData(response, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><users expand=\"user\"/>");
        }
    }
}

