/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.CommentsWithPaginationBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.ztests.tpm.ldap.LdapUtil;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.LIMITS, Category.LDAP, Category.TPM})
@LoginAs(user="admin")
public class TestCommentResourceSafeguardsLdap
extends EmailBaseFuncTestCase {
    private static final String TEST_EDIT_COMMENT_XML_RESOURCE = "TestEditComment.xml";
    private static final String ISSUE_KEY_HSP_2 = "HSP-2";
    private static final String JIRA_SAFEGUARDS_CONFIG_RESTRICTED_GROUPS = "jira.safeguards.config.restricted.groups";
    private static final String BOT_GROUP_1 = "bot-group-1";
    private static final String BOT_GROUP_2 = "bot-group-2";
    private static final String CHILD_GROUP = "child-bot-group";
    private static final String CHILD_GROUP2 = "child2-bot-group";
    private static final String PARENT_GROUP = "parent-bot-group";
    private static final String BOT_GROUPS = "bot-group-1,bot-group-2";
    private static final String BOT_USER_1 = "bot-1";
    private static final String BOT_USER_2 = "bot-2";
    private CommentClient commentClient;
    @Inject
    protected LdapUtil ldapUtil;

    @Before
    public void setUpTest() {
        this.commentClient = new CommentClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testAddCommentAboveLimitIsForbiddenForUsersPartOfNestedBotGroup() throws InterruptedException {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.applicationProperties().setString(JIRA_SAFEGUARDS_CONFIG_RESTRICTED_GROUPS, BOT_GROUP_1);
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "0");
        this.ldapUtil.createLdapDirectory();
        this.ensureGroup(BOT_GROUP_1);
        this.ensureGroup(CHILD_GROUP);
        this.ensureGroup(CHILD_GROUP2);
        this.ensureBotUser();
        this.backdoor.usersAndGroups().addGroupToGroup(CHILD_GROUP2, CHILD_GROUP);
        this.backdoor.usersAndGroups().addGroupToGroup(CHILD_GROUP, BOT_GROUP_1);
        this.backdoor.usersAndGroups().addUserToGroup(BOT_USER_1, CHILD_GROUP2);
        this.commentClient.loginAs(BOT_USER_1);
        this.assertAddingCommentIsForbidden();
        this.assertNumberOfCommentForIssue(0);
    }

    @Test
    public void testAddCommentAboveLimitIsForbiddenForUsersPartOfNestedBotGroups() throws InterruptedException {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.applicationProperties().setString(JIRA_SAFEGUARDS_CONFIG_RESTRICTED_GROUPS, BOT_GROUPS);
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "0");
        this.ldapUtil.createLdapDirectory();
        this.ensureGroup(BOT_GROUP_1);
        this.ensureGroup(BOT_GROUP_2);
        this.ensureGroup(CHILD_GROUP);
        this.ensureGroup(CHILD_GROUP2);
        this.ensureBotUser();
        this.backdoor.usersAndGroups().addGroupToGroup(CHILD_GROUP2, CHILD_GROUP);
        this.backdoor.usersAndGroups().addGroupToGroup(CHILD_GROUP, BOT_GROUP_1);
        this.backdoor.usersAndGroups().addUserToGroup(BOT_USER_1, CHILD_GROUP2);
        this.backdoor.usersAndGroups().addUserToGroup(BOT_USER_2, BOT_GROUP_2);
        this.commentClient.loginAs(BOT_USER_1);
        this.assertAddingCommentIsForbidden();
        this.assertNumberOfCommentForIssue(0);
        this.commentClient.loginAs(BOT_USER_2);
        this.assertAddingCommentIsForbidden();
        this.assertNumberOfCommentForIssue(0);
        this.commentClient.loginAs("admin");
        this.assertAddingCommentIsAllowed();
        this.assertNumberOfCommentForIssue(1);
        this.commentClient.loginAs(BOT_USER_1);
        this.assertAddingCommentIsForbidden();
        this.assertNumberOfCommentForIssue(1);
        this.commentClient.loginAs(BOT_USER_2);
        this.assertAddingCommentIsForbidden();
        this.assertNumberOfCommentForIssue(1);
    }

    @Test
    public void testAddCommentAboveLimitIsAllowedForUsersInParentGroupOfBotGroup() throws InterruptedException {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.applicationProperties().setString(JIRA_SAFEGUARDS_CONFIG_RESTRICTED_GROUPS, BOT_GROUP_1);
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "0");
        this.ldapUtil.createLdapDirectory();
        this.ensureGroup(BOT_GROUP_1);
        this.ensureGroup(PARENT_GROUP);
        this.ensureBotUser();
        this.backdoor.usersAndGroups().addGroupToGroup(BOT_GROUP_1, PARENT_GROUP);
        this.backdoor.usersAndGroups().addUserToGroup(BOT_USER_1, PARENT_GROUP);
        this.commentClient.loginAs(BOT_USER_1);
        this.assertAddingCommentIsAllowed();
        this.assertNumberOfCommentForIssue(1);
    }

    private void ensureGroup(String groupName) {
        if (this.backdoor.usersAndGroups().groupExists(groupName)) {
            this.backdoor.usersAndGroups().deleteGroup(groupName);
        }
        this.backdoor.usersAndGroups().addGroup(groupName);
    }

    private void ensureBotUser() {
        if (this.backdoor.usersAndGroups().userExists(BOT_USER_1)) {
            this.backdoor.usersAndGroups().deleteUser(BOT_USER_1);
        }
        this.backdoor.usersAndGroups().addUser(BOT_USER_1, BOT_USER_1, BOT_USER_1, "jiratest@atlassian.com");
        if (this.backdoor.usersAndGroups().userExists(BOT_USER_2)) {
            this.backdoor.usersAndGroups().deleteUser(BOT_USER_2);
        }
        this.backdoor.usersAndGroups().addUser(BOT_USER_2, BOT_USER_2, BOT_USER_2, "jiratest@atlassian.com");
    }

    private Comment createNewComment() {
        Comment comment = new Comment();
        comment.body = "comment";
        return comment;
    }

    private void assertAddingCommentIsAllowed() {
        ParsedResponse post = this.commentClient.post(ISSUE_KEY_HSP_2, this.createNewComment());
        Assert.assertEquals((long)201L, (long)post.statusCode);
    }

    private void assertAddingCommentIsForbidden() {
        ParsedResponse post = this.commentClient.post(ISSUE_KEY_HSP_2, this.createNewComment());
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
        Assert.assertEquals((Object)"This issue already reached maximum number of allowed comments and you can't add more.", post.entity.errors.get("comment"));
    }

    private void assertNumberOfCommentForIssue(int i) {
        ParsedResponse comments = this.commentClient.getComments(ISSUE_KEY_HSP_2);
        Assert.assertEquals((long)i, (long)((CommentsWithPaginationBean)comments.body).getTotal().intValue());
    }
}

