/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.tpm.ldap.LdapUtil;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestDelegatingLdapDirectoryMaintenance
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;
    @Inject
    protected FuncTestLogger logger;
    @Inject
    protected Assertions assertions;
    @Inject
    protected LdapUtil ldapUtil;
    @Inject
    private TextAssertions textAssertions;
    private String internalDirectoryName;

    @Before
    public void setUp() {
        this.internalDirectoryName = this.ldapUtil.getInternalDirectoryName();
    }

    @Test
    public void testAddDelegatingLdapDirectory() {
        this.navigation.gotoAdmin();
        this.addDirectory();
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Delegating Ldap", this.ldapUtil.getTypeDisplayName()).hasMoveUp(true).hasMoveDown(false).hasDisableEditOperations();
    }

    private void addDirectory() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/delegatingldap/");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-delegating-ldap-form");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("port", "");
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Name is a required field.");
        this.textAssertions.assertTextPresent("Hostname is a required field.");
        this.textAssertions.assertTextPresent("Port is a required field.");
        this.textAssertions.assertTextPresent("User name attribute is a required field");
        this.tester.setWorkingForm("configure-delegating-ldap-form");
        this.tester.setFormElement("name", "First Delegating Ldap");
        this.tester.selectOption("type", this.ldapUtil.getTypeDisplayName());
        this.tester.setFormElement("hostname", this.ldapUtil.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapUserdn", this.ldapUtil.getUserDn());
        this.tester.setFormElement("ldapPassword", this.ldapUtil.getPassword());
        this.tester.setFormElement("ldapBasedn", this.ldapUtil.getBaseDn());
        this.tester.setFormElement("ldapUserUsername", "cn");
        this.tester.submit("test");
        this.tester.submit("save");
    }

    @Test
    public void testEditDelegatingLdapDirectory() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setFormElement("name", "First Delegating Ldap X");
        this.tester.setFormElement("hostname", this.ldapUtil.getLdapServer());
        this.tester.setFormElement("ldapPassword", this.ldapUtil.getPassword());
        this.tester.submit("test");
        this.tester.submit("save");
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Delegating Ldap X", this.ldapUtil.getTypeDisplayName()).hasMoveUp(true).hasMoveDown(false).hasDisableEditOperations();
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("hostname", "");
        this.tester.setFormElement("port", "");
        this.tester.setFormElement("ldapUserdn", "");
        this.tester.setFormElement("ldapPassword", "");
        this.tester.setFormElement("ldapBasedn", "");
        this.tester.setFormElement("ldapUserUsername", "");
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Name is a required field.");
        this.textAssertions.assertTextPresent("Hostname is a required field.");
        this.textAssertions.assertTextPresent("Port is a required field.");
        this.textAssertions.assertTextPresent("Base DN is a required field for this directory type.");
        this.textAssertions.assertTextPresent("User name attribute is a required field");
        this.tester.clickLink("configure-delegating-ldap-form-cancel");
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Delegating Ldap X", this.ldapUtil.getTypeDisplayName()).hasMoveUp(true).hasMoveDown(false).hasDisableEditOperations();
    }

    @Test
    public void testDeleteDelegatingLdapDirectory() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Disable");
        this.navigation.clickLinkWithPost(link);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Delegating Ldap (inactive)", this.ldapUtil.getTypeDisplayName()).hasMoveUp(true).hasMoveDown(false).hasEnableEditRemoveOperations();
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Remove");
        this.navigation.clickLinkWithPost(link);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(false).hasOnlyEditOperation();
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, "embcwd"), "First Delegating Ldap");
    }
}

