/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.tpm.ldap.LdapUtil;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestLdapDirectoryMaintenance
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;
    @Inject
    protected FuncTestLogger logger;
    @Inject
    protected Assertions assertions;
    @Inject
    protected LdapUtil ldapUtil;
    @Inject
    private TextAssertions textAssertions;
    private String internalDirectoryName;

    @Before
    public void setUpTest() {
        this.internalDirectoryName = this.ldapUtil.getInternalDirectoryName();
    }

    @Test
    public void testAddLdapDirectory() {
        this.navigation.gotoAdmin();
        this.addDirectory();
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Ldap", this.ldapUtil.getTypeDisplayName() + " (Read Only)").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        Assert.assertEquals((Object)"First Ldap", (Object)this.tester.getDialog().getElement("configure-ldap-form-name").getAttribute("value"));
        Assert.assertEquals((Object)this.ldapUtil.getLdapServer(), (Object)this.tester.getDialog().getElement("configure-ldap-form-hostname").getAttribute("value"));
        Assert.assertEquals((Object)"389", (Object)this.tester.getDialog().getElement("configure-ldap-form-port").getAttribute("value"));
        Assert.assertEquals((Object)this.ldapUtil.getBaseDn(), (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapBasedn").getAttribute("value"));
        Assert.assertEquals((Object)this.ldapUtil.getUserDn(), (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserdn").getAttribute("value"));
        this.tester.assertTextNotPresent(this.ldapUtil.getPassword());
        MatcherAssert.assertThat((Object)this.tester.getDialog().getElement("configure-ldap-form-ldapPassword").getAttribute("class"), (Matcher)Matchers.containsString((String)"password_value_placeholder"));
        Assert.assertEquals((Object)"inetorgperson", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserObjectclass").getAttribute("value"));
        Assert.assertEquals((Object)"(objectclass=inetorgperson)", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserFilter").getAttribute("value"));
        Assert.assertEquals((Object)"cn", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserUsername").getAttribute("value"));
        Assert.assertEquals((Object)"cn", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserUsernameRdn").getAttribute("value"));
        Assert.assertEquals((Object)"givenName", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserFirstname").getAttribute("value"));
        Assert.assertEquals((Object)"sn", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserLastname").getAttribute("value"));
        Assert.assertEquals((Object)"displayName", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserDisplayname").getAttribute("value"));
        Assert.assertEquals((Object)"mail", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserEmail").getAttribute("value"));
        Assert.assertEquals((Object)"memberOf", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserGroup").getAttribute("value"));
        Assert.assertEquals((Object)"userPassword", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserPassword").getAttribute("value"));
        Assert.assertEquals((Object)"groupOfUniqueNames", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupObjectclass").getAttribute("value"));
        Assert.assertEquals((Object)"(objectclass=groupOfUniqueNames)", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupFilter").getAttribute("value"));
        Assert.assertEquals((Object)"cn", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupName").getAttribute("value"));
        Assert.assertEquals((Object)"description", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupDescription").getAttribute("value"));
        Assert.assertEquals((Object)"uniqueMember", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupUsernames").getAttribute("value"));
    }

    private void addDirectory() {
        this.addDirectory(false);
    }

    private void addDirectory(boolean writable) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("port", "");
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Name is a required field.");
        this.textAssertions.assertTextPresent("Hostname is a required field.");
        this.textAssertions.assertTextPresent("Port is a required field.");
        this.textAssertions.assertTextPresent("User object class is a required field.");
        this.textAssertions.assertTextPresent("User object filter is a required field.");
        this.textAssertions.assertTextPresent("User name attribute is a required field.");
        this.textAssertions.assertTextPresent("First name attribute is a required field.");
        this.textAssertions.assertTextPresent("Last name attribute is a required field.");
        this.textAssertions.assertTextPresent("User display name attribute is a required field.");
        this.textAssertions.assertTextPresent("User email attribute is a required field.");
        this.textAssertions.assertTextPresent("User group attribute is a required field.");
        this.textAssertions.assertTextPresent("User password attribute is a required field.");
        this.textAssertions.assertTextPresent("Group object class is a required field.");
        this.textAssertions.assertTextPresent("Group object filter is a required field.");
        this.textAssertions.assertTextPresent("Group name attribute is a required field.");
        this.textAssertions.assertTextPresent("Group description attribute is a required field.");
        this.textAssertions.assertTextPresent("Group members attribute is a required field.");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", "First Ldap");
        if (this.ldapUtil.isActiveDirectory()) {
            this.tester.selectOption("type", "Microsoft Active Directory");
        } else {
            this.tester.selectOption("type", "OpenLDAP");
        }
        this.tester.setFormElement("hostname", this.ldapUtil.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapBasedn", this.ldapUtil.getBaseDn());
        this.tester.setFormElement("ldapUserdn", this.ldapUtil.getUserDn());
        this.tester.setFormElement("ldapPassword", this.ldapUtil.getPassword());
        this.tester.setFormElement("ldapUserObjectclass", "inetorgperson");
        this.tester.setFormElement("ldapUserFilter", "(objectclass=inetorgperson)");
        this.tester.setFormElement("ldapUserUsername", "cn");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "userPassword");
        this.tester.setFormElement("ldapGroupObjectclass", "groupOfUniqueNames");
        this.tester.setFormElement("ldapGroupFilter", "(objectclass=groupOfUniqueNames)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "uniqueMember");
        if (writable) {
            this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        }
        this.tester.submit("test");
        this.tester.submit("save");
        this.ldapUtil.assertExtendedTestPageAndReturnToDirectoryList();
    }

    @Test
    public void testEditLdapDirectory() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        WebLink link = tblDirectoryList.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", "First Ldap X");
        this.tester.setFormElement("hostname", this.ldapUtil.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapBasedn", this.ldapUtil.getBaseDn());
        this.tester.setFormElement("ldapUserdn", this.ldapUtil.getUserDn());
        this.tester.setFormElement("ldapPassword", this.ldapUtil.getPassword());
        this.tester.setFormElement("ldapUserObjectclass", "inetorgpersonX");
        this.tester.setFormElement("ldapUserFilter", "(objectclass=inetorgperson)X");
        this.tester.setFormElement("ldapUserUsername", "cnX");
        this.tester.setFormElement("ldapUserUsernameRdn", "cnX");
        this.tester.setFormElement("ldapUserFirstname", "givenNameX");
        this.tester.setFormElement("ldapUserLastname", "snX");
        this.tester.setFormElement("ldapUserDisplayname", "displayNameX");
        this.tester.setFormElement("ldapUserEmail", "mailX");
        this.tester.setFormElement("ldapUserGroup", "memberOfX");
        this.tester.setFormElement("ldapUserPassword", "userPasswordX");
        this.tester.setFormElement("ldapGroupObjectclass", "groupOfUniqueNamesX");
        this.tester.setFormElement("ldapGroupFilter", "(objectclass=groupOfUniqueNames)X");
        this.tester.setFormElement("ldapGroupName", "cnX");
        this.tester.setFormElement("ldapGroupDescription", "descriptionX");
        this.tester.setFormElement("ldapGroupUsernames", "uniqueMemberX");
        this.tester.submit("test");
        this.tester.submit("save");
        this.ldapUtil.assertExtendedTestPageAndReturnToDirectoryList();
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Ldap X", this.ldapUtil.getTypeDisplayName() + " (Read Only)").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        link = tblDirectoryList.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        Assert.assertEquals((Object)"First Ldap X", (Object)this.tester.getDialog().getElement("configure-ldap-form-name").getAttribute("value"));
        Assert.assertEquals((Object)this.ldapUtil.getLdapServer(), (Object)this.tester.getDialog().getElement("configure-ldap-form-hostname").getAttribute("value"));
        Assert.assertEquals((Object)"389", (Object)this.tester.getDialog().getElement("configure-ldap-form-port").getAttribute("value"));
        Assert.assertEquals((Object)this.ldapUtil.getBaseDn(), (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapBasedn").getAttribute("value"));
        Assert.assertEquals((Object)this.ldapUtil.getUserDn(), (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserdn").getAttribute("value"));
        this.tester.assertTextNotPresent(this.ldapUtil.getPassword());
        MatcherAssert.assertThat((Object)this.tester.getDialog().getElement("configure-ldap-form-ldapPassword").getAttribute("class"), (Matcher)Matchers.containsString((String)"password_value_placeholder"));
        Assert.assertEquals((Object)"inetorgpersonX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserObjectclass").getAttribute("value"));
        Assert.assertEquals((Object)"(objectclass=inetorgperson)X", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserFilter").getAttribute("value"));
        Assert.assertEquals((Object)"cnX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserUsername").getAttribute("value"));
        Assert.assertEquals((Object)"cnX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserUsernameRdn").getAttribute("value"));
        Assert.assertEquals((Object)"givenNameX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserFirstname").getAttribute("value"));
        Assert.assertEquals((Object)"snX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserLastname").getAttribute("value"));
        Assert.assertEquals((Object)"displayNameX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserDisplayname").getAttribute("value"));
        Assert.assertEquals((Object)"mailX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserEmail").getAttribute("value"));
        Assert.assertEquals((Object)"memberOfX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserGroup").getAttribute("value"));
        Assert.assertEquals((Object)"userPasswordX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapUserPassword").getAttribute("value"));
        Assert.assertEquals((Object)"groupOfUniqueNamesX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupObjectclass").getAttribute("value"));
        Assert.assertEquals((Object)"(objectclass=groupOfUniqueNames)X", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupFilter").getAttribute("value"));
        Assert.assertEquals((Object)"cnX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupName").getAttribute("value"));
        Assert.assertEquals((Object)"descriptionX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupDescription").getAttribute("value"));
        Assert.assertEquals((Object)"uniqueMemberX", (Object)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupUsernames").getAttribute("value"));
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("hostname", "");
        this.tester.setFormElement("port", "");
        this.tester.setFormElement("ldapBasedn", "");
        this.tester.setFormElement("ldapUserdn", "");
        this.tester.setFormElement("ldapPassword", "");
        this.tester.setFormElement("ldapUserObjectclass", "");
        this.tester.setFormElement("ldapUserFilter", "");
        this.tester.setFormElement("ldapUserUsername", "");
        this.tester.setFormElement("ldapUserUsernameRdn", "");
        this.tester.setFormElement("ldapUserFirstname", "");
        this.tester.setFormElement("ldapUserLastname", "");
        this.tester.setFormElement("ldapUserDisplayname", "");
        this.tester.setFormElement("ldapUserEmail", "");
        this.tester.setFormElement("ldapUserGroup", "");
        this.tester.setFormElement("ldapUserPassword", "");
        this.tester.setFormElement("ldapGroupObjectclass", "");
        this.tester.setFormElement("ldapGroupFilter", "");
        this.tester.setFormElement("ldapGroupName", "");
        this.tester.setFormElement("ldapGroupDescription", "");
        this.tester.setFormElement("ldapGroupUsernames", "");
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Name is a required field.");
        this.textAssertions.assertTextPresent("Hostname is a required field.");
        this.textAssertions.assertTextPresent("Port is a required field.");
        this.textAssertions.assertTextPresent("User object class is a required field.");
        this.textAssertions.assertTextPresent("User object filter is a required field.");
        this.textAssertions.assertTextPresent("User name attribute is a required field.");
        this.textAssertions.assertTextPresent("First name attribute is a required field.");
        this.textAssertions.assertTextPresent("Last name attribute is a required field.");
        this.textAssertions.assertTextPresent("User display name attribute is a required field.");
        this.textAssertions.assertTextPresent("User email attribute is a required field.");
        this.textAssertions.assertTextPresent("User group attribute is a required field.");
        this.textAssertions.assertTextPresent("User password attribute is a required field.");
        this.textAssertions.assertTextPresent("Group object class is a required field.");
        this.textAssertions.assertTextPresent("Group object filter is a required field.");
        this.textAssertions.assertTextPresent("Group name attribute is a required field.");
        this.textAssertions.assertTextPresent("Group description attribute is a required field.");
        this.textAssertions.assertTextPresent("Group members attribute is a required field.");
        this.tester.clickLink("configure-ldap-form-cancel");
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Ldap X", this.ldapUtil.getTypeDisplayName() + " (Read Only)").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        link = tblDirectoryList.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.submit("test");
        this.tester.submit("save");
        this.ldapUtil.assertExtendedTestPageAndReturnToDirectoryList();
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Ldap X", this.ldapUtil.getTypeDisplayName() + " (Read Only)").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
    }

    @Test
    public void testDeleteLdapDirectory() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Disable");
        this.navigation.clickLinkWithPost(link);
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Ldap (inactive)", this.ldapUtil.getTypeDisplayName() + " (Read Only)").hasMoveUp(true).hasMoveDown(false).hasEnableEditRemoveSynchroniseOperations();
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Remove");
        this.navigation.clickLinkWithPost(link);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(false).hasOnlyEditOperation();
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, "embcwd"), "First Ldap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCantMoveLdapDirWhenAdminLost() {
        UserDirectoryTable userDirectoryTable;
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory(true);
        try {
            userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
            userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true);
            userDirectoryTable.assertRow(2).contains("10000", "First Ldap", this.ldapUtil.getTypeDisplayName() + " (Read/Write)").hasMoveUp(true).hasMoveDown(false);
            this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
            String username = "jra23861";
            String password = "password";
            this.tester.setFormElement("username", username);
            this.tester.setFormElement("fullname", username);
            this.tester.setFormElement("password", password);
            this.tester.setFormElement("email", "jra23861@example.com");
            this.tester.submit("Create");
            this.administration.usersAndGroups().addUserToGroup(username, "jira-administrators");
            try {
                this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
                this.tester.setFormElement("username", username);
                this.tester.setFormElement("directoryId", "10000");
                this.tester.setFormElement("fullname", username);
                this.tester.setFormElement("password", password);
                this.tester.setFormElement("email", "jra23861@example.com");
                this.tester.submit("Create");
                try {
                    this.navigation.logout();
                    this.navigation.login(username, password);
                    this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
                    this.textAssertions.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
                    userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
                    userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true);
                    userDirectoryTable.assertRow(2).contains("10000", "First Ldap", this.ldapUtil.getTypeDisplayName() + " (Read/Write)").hasMoveUp(true).hasMoveDown(false);
                    WebLink link = userDirectoryTable.getTableCell(2, 3).getLinkWith("up");
                    this.navigation.clickLinkWithPost(link);
                    this.tester.assertTextPresent("You cannot move the directory without losing your system admin privileges.");
                    userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
                    userDirectoryTable.assertRow(1).contains("1", this.internalDirectoryName, "Internal").hasMoveUp(false).hasMoveDown(true);
                    userDirectoryTable.assertRow(2).contains("10000", "First Ldap", this.ldapUtil.getTypeDisplayName() + " (Read/Write)").hasMoveUp(true).hasMoveDown(false);
                }
                finally {
                    this.navigation.logout();
                    this.navigation.login("admin", "admin");
                    this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
                    this.tester.clickLink("deleteuser_link");
                    this.tester.submit("Delete");
                }
            }
            finally {
                this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
                this.tester.clickLink("deleteuser_link");
                this.tester.submit("Delete");
            }
        }
        finally {
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
            userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
            WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Disable");
            this.navigation.clickLinkWithPost(link);
            userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
            link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Remove");
            this.navigation.clickLinkWithPost(link);
        }
    }
}

