/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.PluginsControlExt;
import com.atlassian.jira.functest.framework.backdoor.upgrade.PluginUpgradeDetailsJsonBean;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestNoNewSalUpgrades
extends BaseJiraFuncTest {
    @Test
    public void generatePropertiesFile() throws IOException {
        this.backdoor.restoreBlankInstance();
        List<String> installedPlugins = this.getPluginKeys();
        System.out.println("========================================================");
        System.out.println("  Printing contents of plugin-build-numbers.properties");
        System.out.println("========================================================");
        System.out.println();
        Properties properties = new Properties();
        for (String plugin : installedPlugins) {
            Optional<PluginUpgradeDetailsJsonBean> maybeDetails = this.getPluginUpgradeDetails(plugin);
            maybeDetails.ifPresent(details -> Arrays.stream(BuildNumber.values()).forEach(number -> {
                Integer buildNumber = (Integer)((BuildNumber)number).buildNumberFunction.apply(details);
                if (buildNumber > 0) {
                    properties.setProperty(number.propertyName(plugin), String.valueOf(buildNumber));
                }
            }));
        }
        properties.store(System.out, "");
        System.out.println();
    }

    @Test
    public void verifyThatNoNewSalOrAoUpgradesArePresent() throws IOException {
        this.backdoor.restoreBlankInstance();
        Properties properties = new Properties();
        properties.load(this.getClass().getResource("plugin-build-numbers.properties").openStream());
        List<String> installedPlugins = this.getPluginKeys();
        for (String plugin : installedPlugins) {
            Optional<PluginUpgradeDetailsJsonBean> maybeDetails = this.getPluginUpgradeDetails(plugin);
            maybeDetails.ifPresent(details -> Arrays.stream(BuildNumber.values()).forEach(number -> {
                String buildNumber = properties.getProperty(number.propertyName(plugin));
                Integer currentBuildNumber = (Integer)((BuildNumber)number).buildNumberFunction.apply(details);
                if (buildNumber == null) {
                    MatcherAssert.assertThat((String)String.format("Non-whitelisted plugin \"%1s\" has %2s upgrade tasks", plugin, number.name()), (Object)currentBuildNumber, (Matcher)Matchers.is((Object)0));
                } else {
                    MatcherAssert.assertThat((String)String.format("Whitelisted plugin \"%1s\" added %2s upgrade tasks", plugin, number.name()), (Object)currentBuildNumber, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(buildNumber)));
                }
            }));
        }
    }

    private List<String> getPluginKeys() {
        return this.backdoor.plugins().listPlugins().stream().map(PluginsControlExt.PluginBean::getKey).collect(Collectors.toList());
    }

    private Optional<PluginUpgradeDetailsJsonBean> getPluginUpgradeDetails(String installedPlugin) {
        try {
            return Optional.of(this.backdoor.upgradeControl().getPluginDetails(installedPlugin));
        }
        catch (WebApplicationException e) {
            Document entity = Jsoup.parse((String)((String)e.getResponse().readEntity(String.class)), (String)"", (Parser)Parser.xmlParser());
            if (!entity.getElementsByTag("message").text().contains("must be an OsgiPlugin")) {
                throw new RuntimeException("Could not get plugin details", e);
            }
            return Optional.empty();
        }
    }

    static enum BuildNumber {
        AO(PluginUpgradeDetailsJsonBean::getAoBuildNumber),
        SAL(PluginUpgradeDetailsJsonBean::getSalBuildNumber);

        private final Function<PluginUpgradeDetailsJsonBean, Integer> buildNumberFunction;

        private BuildNumber(Function<PluginUpgradeDetailsJsonBean, Integer> buildNumberFunction) {
            this.buildNumberFunction = buildNumberFunction;
        }

        String propertyName(String pluginKey) {
            return pluginKey + "." + this.name();
        }
    }
}

