/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckOptionsUtils;
import com.atlassian.jira.functest.config.ConfigFile;
import com.atlassian.jira.functest.config.ConfigFileWalker;
import com.atlassian.jira.functest.config.ConfigurationDefaults;
import com.atlassian.jira.functest.config.JiraConfig;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.ExportControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.SlowTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebTest(value={Category.FUNC_TEST, Category.INFRASTRUCTURE, Category.SLOW_IMPORT})
@LoginAs(user="admin")
public class TestUpgradeXmlData
extends BaseJiraFuncTest
implements ConfigFileWalker.ConfigVisitor {
    private static final Logger log = LoggerFactory.getLogger(TestUpgradeXmlData.class);
    private static final String JIRA_XML_UPGRADE_DATA_LOCATION = "jira.xml.upgrade.dataLocation";
    private static final String JIRA_XML_UPGRADE_ADD_SUPPRESS_OPTIONS = "jira.xml.upgrade.add.suppress.options";
    private List<File> brokenFiles = new LinkedList<File>();
    private long currentBuildNumber;
    private File dataLocation;
    @Inject
    private Administration administration;

    private static String getRelativeFile(File base, File file) {
        String basePath = base.getPath();
        String filePath = file.getPath();
        if (filePath != null && filePath.startsWith(basePath)) {
            String s = filePath.substring(basePath.length());
            if (s.startsWith(File.separator)) {
                s = s.substring(File.separator.length());
            }
            return s;
        }
        return file.getName();
    }

    private static File normalizeFile(File importFile) {
        try {
            return importFile.getCanonicalFile();
        }
        catch (IOException e) {
            return importFile.getAbsoluteFile();
        }
    }

    @Test
    @SlowTest
    public void testUpgradeTestData() throws Exception {
        this.dataLocation = this.getDataLocation();
        log.debug(String.format("Using the following data location %s ", this.dataLocation.getAbsolutePath()));
        this.currentBuildNumber = this.backdoor.serverInfo().get().getBuildNumber();
        ConfigFileWalker fileWalker = new ConfigFileWalker(this.dataLocation, this);
        fileWalker.setExcludes(ConfigurationDefaults.getDefaultExcludedFilters());
        fileWalker.walk();
        if (!this.brokenFiles.isEmpty()) {
            StringWriter writer = new StringWriter();
            PrintWriter builder = new PrintWriter(writer);
            builder.println("Unable to update all the XML.");
            for (File brokenFile : this.brokenFiles) {
                builder.format("\t%s%n", brokenFile.getAbsolutePath());
            }
            builder.close();
            Assert.fail((String)writer.toString());
        }
        this.dataLocation = null;
        this.brokenFiles = null;
    }

    @Override
    public void visitConfig(ConfigFile entitiesFile) {
        File importFile = entitiesFile.getFile();
        log.info("processing file: {}", (Object)importFile);
        Document entitiesDocument = entitiesFile.readConfig();
        CheckOptions checkOptions = CheckOptionsUtils.parseOptions(entitiesDocument);
        if (!checkOptions.checkEnabled("upgrade")) {
            log.info(String.format("Not upgrading '%s' as it contains the '%s' suppresscheck flag.", importFile, "upgrade"));
            return;
        }
        if (!JiraConfig.isJiraXml(entitiesDocument)) {
            this.brokenFiles.add(importFile);
            log.error(String.format("Not upgrading '%s' as it does not appear to be a JIRA backup.", importFile));
            return;
        }
        JiraConfig config = new JiraConfig(entitiesDocument, importFile);
        long dataBuildNumber = config.getBuildNumber();
        if (dataBuildNumber >= this.currentBuildNumber) {
            log.warn(String.format("Not upgrading '%s' as data build number (%s) is greater than instance build number (%s).", importFile.getAbsolutePath(), dataBuildNumber, this.currentBuildNumber));
            return;
        }
        if (!this.restoreDataSafely(importFile)) {
            this.brokenFiles.add(importFile);
            return;
        }
        File newFile = ((ExportControl)this.backdoor.export().loginAs("admin")).export(importFile.getName());
        if ("xml".equals(FilenameUtils.getExtension((String)importFile.getName()))) {
            try {
                InputStream inputStream = new ZipFile(newFile).getInputStream(new ZipEntry("entities.xml"));
                File extractedXml = new File(newFile.getParentFile(), importFile.getName());
                try {
                    FileUtils.forceDelete((File)extractedXml);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                FileWriter fileWriter = new FileWriter(extractedXml);
                IOUtils.copy((InputStream)inputStream, (Writer)fileWriter);
                fileWriter.close();
                newFile = extractedXml;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ConfigFile newConfigFile = ConfigFile.create(newFile);
        Document newDocument = newConfigFile.readConfig();
        CheckOptionsUtils.writeOptions(newDocument, CheckOptionsUtils.disableIn(checkOptions, this.extraDisabledOptions()));
        newConfigFile.writeFile(newDocument);
        try {
            Files.move(newFile.toPath(), importFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String[] extraDisabledOptions() {
        if (Boolean.getBoolean(JIRA_XML_UPGRADE_ADD_SUPPRESS_OPTIONS)) {
            List<String> keyList = ConfigurationDefaults.getListOfDefaultConfigurationChecksSuppressKeys();
            return keyList.toArray(new String[keyList.size()]);
        }
        return new String[0];
    }

    @Override
    public void visitConfigError(File file, ConfigFile.ConfigFileException e) {
        throw e;
    }

    private File getDataLocation() {
        String fromSystem = System.getProperty(JIRA_XML_UPGRADE_DATA_LOCATION);
        if (fromSystem != null) {
            log.info("+++ Using property JIRA_XML_UPGRADE_DATA_LOCATION value: " + fromSystem);
            return TestUpgradeXmlData.normalizeFile(new File(fromSystem));
        }
        File xmlDataLocation = ConfigurationDefaults.getDefaultXmlDataLocation();
        log.info("+++ Using default value: " + xmlDataLocation.getAbsolutePath());
        return TestUpgradeXmlData.normalizeFile(xmlDataLocation);
    }

    private boolean restoreDataSafely(File file) {
        try {
            this.copyFileToDataLocation(file);
            this.backdoor.restoreDataFromResource(TestUpgradeXmlData.getRelativeFile(this.dataLocation, file));
            return true;
        }
        catch (Throwable e) {
            log.error("Unable to restore '" + file.getAbsolutePath() + "'.", e);
            return false;
        }
    }

    private void copyFileToDataLocation(File file) throws IOException {
        File destination = this.getDestinationFile(file);
        if (file.getParent().equals(destination.getPath())) {
            log.warn(String.format("Not copying %s to %s as source and destination is the same", file.getName(), destination.getPath()));
        } else {
            FileUtils.copyFileToDirectory((File)file, (File)destination);
        }
    }

    private File getDestinationFile(File file) {
        File subdirectoryWithinSource = new File(TestUpgradeXmlData.getRelativeFile(this.dataLocation, file)).getParentFile();
        File destination = subdirectoryWithinSource != null ? this.getSubdirectoryWithinTarget(subdirectoryWithinSource) : this.environmentData.getXMLDataLocation();
        return destination;
    }

    private File getSubdirectoryWithinTarget(File subdirectoryWithinDataLocation) {
        return new File(this.environmentData.getXMLDataLocation().getPath() + File.separator + subdirectoryWithinDataLocation.getPath());
    }
}

