/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade;

import com.atlassian.jira.rest.v2.upgrade.UpgradeResultBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;

public class UpgradeManagerClient
extends RestApiClient {
    private final JIRAEnvironmentData environmentData;

    public UpgradeManagerClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.environmentData = environmentData;
    }

    public void addUpgradeTask(String task) {
        this.getUpgradeBackDoor().path("addUpgrade").queryParam("task", new Object[]{task}).request().post(null, String.class);
    }

    public void doUpgrade() {
        this.getUpgradeBackDoor().path("doUpgrade").request().post(null, String.class);
    }

    public void doDelayedUpgradesAndWaitForCompletion() {
        this.getUpgradeResource().request().post(null, String.class);
        boolean upgradeComplete = false;
        do {
            try {
                UpgradeResultBean result = (UpgradeResultBean)this.getUpgradeResource().request().get(UpgradeResultBean.class);
                upgradeComplete = true;
            }
            catch (WebApplicationException e) {
                upgradeComplete = e.getResponse().getStatus() != 303;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        } while (!upgradeComplete);
    }

    private WebTarget getUpgradeResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path("2").path("upgrade");
    }

    private WebTarget getUpgradeBackDoor() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("func-test").path("1.0").path("upgradeManager");
    }
}

