/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.project.type.ProjectTypeKey;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask70101
extends BaseJiraFuncTest {
    private static final long PROJECT_1 = 10000L;
    private static final long PROJECT_2 = 10001L;
    private static final long PROJECT_3 = 10002L;
    private static final long PROJECT_4 = 10003L;
    private static final long PROJECT_5 = 10004L;

    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance();
    }

    @Test
    public void projectsReceivedExpectedProjectType() {
        this.backdoor.restoreDataFromResource("TestUpgradeTask70101.zip");
        this.assertProjectHasType(10000L, "software");
        this.assertProjectHasType(10001L, "software");
        this.assertProjectHasType(10002L, "service_desk");
        this.assertProjectHasType(10003L, "software");
        this.assertProjectHasType(10004L, "service_desk");
    }

    private void assertProjectHasType(long projectId, String expectedType) {
        ProjectTypeKey projectType = this.backdoor.project().getProjectType(projectId);
        MatcherAssert.assertThat((Object)projectType.getKey(), (Matcher)CoreMatchers.is((Object)expectedType));
    }
}

