/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.PrioritySchemesControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask76001
extends BaseJiraFuncTest {
    @Test
    @SinceBuildRule.SinceBuild(buildNumber=76001)
    public void shouldCreateDefaultPrioritySchemeAfterUpgrade() {
        this.backdoor.restoreDataFromResource("TestUpgradeTask76001.xml");
        List<PrioritySchemesControl.PrioritySchemeData> schemes = this.backdoor.prioritySchemes().getSchemes();
        Assert.assertThat((String)"There should be only default scheme defined", schemes, (Matcher)Matchers.iterableWithSize((int)1));
        PrioritySchemesControl.PrioritySchemeData scheme = schemes.get(0);
        Assert.assertThat((String)"Default priority scheme should contain all priorities in desired order", scheme.getPriorities(), (Matcher)Matchers.contains((Object[])new String[]{"1", "2", "3", "10001", "4", "5", "10000"}));
        Assert.assertThat((String)"Default priority should be mapped to the scheme", (Object)scheme.getDefaultPriority(), (Matcher)Matchers.equalTo((Object)"10001"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=76001)
    public void shouldDefineNewDefaultPriorityIfImportingDataWithDefaultPriorityAlreadyDefined() {
        this.backdoor.restoreDataFromResource("TestUpgradeTask76001_with_priority_scheme_data.xml");
        List<PrioritySchemesControl.PrioritySchemeData> schemes = this.backdoor.prioritySchemes().getSchemes();
        Assert.assertThat((String)"There should be 2 schemes defined", schemes, (Matcher)Matchers.iterableWithSize((int)2));
        PrioritySchemesControl.PrioritySchemeData defaultScheme = schemes.get(0);
        Assert.assertThat((String)"Default priority scheme should contain all priorities in desired order", defaultScheme.getPriorities(), (Matcher)Matchers.contains((Object[])new String[]{"1", "2", "3", "10001", "4", "5", "10000", "10100"}));
        Assert.assertThat((String)"Default priority should be mapped to the scheme", (Object)defaultScheme.getDefaultPriority(), (Matcher)Matchers.equalTo((Object)"10001"));
        PrioritySchemesControl.PrioritySchemeData preDefinedScheme = schemes.get(1);
        Assert.assertThat((String)"Pre-defined scheme still exists and contains one priority", preDefinedScheme.getPriorities(), (Matcher)Matchers.contains((Object[])new String[]{"10100"}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=76001)
    public void shouldNotSetDefaultPrioritySchemeWhenThereIsNoDefined() {
        this.backdoor.restoreDataFromResource("TestUpgradeTask76001-no-default-priority.xml");
        PrioritySchemesControl.PrioritySchemeData scheme = this.backdoor.prioritySchemes().getSchemes().get(0);
        Assert.assertNull((Object)scheme.getDefaultPriority());
    }
}

