/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.DatabaseMaintenanceControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.model.querydsl.QMembership;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask822000
extends BaseJiraFuncTest {
    private static final String NEW_INDEX_NAME_UK_MEM_DIR_PARENT_CHILD = "uk_mem_dir_parent_child";
    private static final String OLD_INDEX_NAME_UK_MEM_PARENT_CHILD_TYPE = "uk_mem_parent_child_type";
    private static final String OLD_INDEX_NAME_IDX_MEM_DIR_PARENT_CHILD = "idx_mem_dir_parent_child";
    private static final String GROUP_BEDROCK = "Bedrock";

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=822000)
    public void testDropOldIndexAndCreateNew() {
        this.restoreIndexesToTheStateBeforeTheUpgradeTask();
        this.backdoor.restoreInstance("TestUpgradeTask822000.xml", LicenseKeys.COMMERCIAL);
        List<DatabaseMaintenanceControl.IndexMetadata> indexesAfterUpgradeTask = this.backdoor.getDatabaseMaintenanceControl().getIndexMetadata(QMembership.MEMBERSHIP.getTableName());
        Set<String> indexNamesAfterUpgradeTask = TestUpgradeTask822000.getIndexNames(indexesAfterUpgradeTask);
        MatcherAssert.assertThat(indexNamesAfterUpgradeTask, (Matcher)Matchers.allOf((Matcher)IsNot.not((Matcher)Matchers.hasItem((Object)OLD_INDEX_NAME_UK_MEM_PARENT_CHILD_TYPE)), (Matcher)IsNot.not((Matcher)Matchers.hasItem((Object)OLD_INDEX_NAME_IDX_MEM_DIR_PARENT_CHILD))));
        DatabaseMaintenanceControl.IndexMetadata newIndexMetadata = indexesAfterUpgradeTask.stream().filter(indexMetadata -> indexMetadata.indexName.equalsIgnoreCase(NEW_INDEX_NAME_UK_MEM_DIR_PARENT_CHILD)).findFirst().orElseThrow(() -> new AssertionError((Object)"Index uk_mem_dir_parent_child not found"));
        MatcherAssert.assertThat(newIndexMetadata.columns, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.equalToIgnoringCase((String)"lower_parent_name"), Matchers.equalToIgnoringCase((String)"lower_child_name"), Matchers.equalToIgnoringCase((String)"membership_type"), Matchers.equalToIgnoringCase((String)"directory_id")}));
        MatcherAssert.assertThat((Object)newIndexMetadata.isUnique, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.backdoor.usersAndGroups().isGroupInGroup("Dino", GROUP_BEDROCK), (Matcher)Matchers.is((Object)true));
        this.assertUserInGroup("Dino", GROUP_BEDROCK);
        this.assertUserInGroup("Fred", GROUP_BEDROCK);
        this.assertUserInGroup("Wilma", GROUP_BEDROCK);
        this.assertUserInGroup("Betty", GROUP_BEDROCK);
        this.assertUserNotInGroup("Barney", GROUP_BEDROCK);
        this.backdoor.usersAndGroups().addUserToGroup("Barney", GROUP_BEDROCK);
        this.assertUserInGroup("Barney", GROUP_BEDROCK);
    }

    private void restoreIndexesToTheStateBeforeTheUpgradeTask() {
        this.backdoor.restoreBlankInstance();
        Set<String> indexNamesBeforeTest = TestUpgradeTask822000.getIndexNames(this.backdoor.getDatabaseMaintenanceControl().getIndexMetadata(QMembership.MEMBERSHIP.getTableName()));
        if (indexNamesBeforeTest.contains(NEW_INDEX_NAME_UK_MEM_DIR_PARENT_CHILD)) {
            this.backdoor.getDatabaseMaintenanceControl().dropIndex(QMembership.MEMBERSHIP.getTableName(), NEW_INDEX_NAME_UK_MEM_DIR_PARENT_CHILD);
        }
        if (!indexNamesBeforeTest.contains(OLD_INDEX_NAME_UK_MEM_PARENT_CHILD_TYPE)) {
            this.backdoor.getDatabaseMaintenanceControl().createIndex(QMembership.MEMBERSHIP.getEntityName(), QMembership.MEMBERSHIP.getTableName(), OLD_INDEX_NAME_UK_MEM_PARENT_CHILD_TYPE, true, (ImmutableMap<String, String>)ImmutableMap.of((Object)"parentId", (Object)"parent_id", (Object)"childId", (Object)"child_id", (Object)"membershipType", (Object)"membership_type"));
        }
        if (!indexNamesBeforeTest.contains(OLD_INDEX_NAME_IDX_MEM_DIR_PARENT_CHILD)) {
            this.backdoor.getDatabaseMaintenanceControl().createIndex(QMembership.MEMBERSHIP.getEntityName(), QMembership.MEMBERSHIP.getTableName(), OLD_INDEX_NAME_IDX_MEM_DIR_PARENT_CHILD, false, (ImmutableMap<String, String>)ImmutableMap.of((Object)"lowerParentName", (Object)"lower_parent_name", (Object)"lowerChildName", (Object)"lower_child_name", (Object)"membershipType", (Object)"membership_type", (Object)"directoryId", (Object)"directory_id"));
        }
        Set<String> indexNamesAfterRestore = TestUpgradeTask822000.getIndexNames(this.backdoor.getDatabaseMaintenanceControl().getIndexMetadata(QMembership.MEMBERSHIP.getTableName()));
        MatcherAssert.assertThat(indexNamesAfterRestore, (Matcher)Matchers.hasItems((Object[])new String[]{OLD_INDEX_NAME_UK_MEM_PARENT_CHILD_TYPE, OLD_INDEX_NAME_IDX_MEM_DIR_PARENT_CHILD}));
    }

    private void assertUserInGroup(String username, String groupName) {
        MatcherAssert.assertThat((Object)this.backdoor.usersAndGroups().isUserInGroup(username, groupName), (Matcher)Matchers.is((Object)true));
    }

    private void assertUserNotInGroup(String username, String groupName) {
        MatcherAssert.assertThat((Object)this.backdoor.usersAndGroups().isUserInGroup(username, groupName), (Matcher)Matchers.is((Object)false));
    }

    private static Set<String> getIndexNames(List<DatabaseMaintenanceControl.IndexMetadata> indexMetadata) {
        return indexMetadata.stream().map(i -> i.indexName).map(String::toLowerCase).collect(Collectors.toSet());
    }
}

