/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
@Restore(value="blankprojects.xml")
public class TestUpgradeTask_Build814000
extends BaseJiraFuncTest {
    private static final List<String> ROOT_TEMPLATES = Arrays.asList("issuecreated.vm", "issueupdated.vm", "issueassigned.vm", "issueresolved.vm", "issueclosed.vm", "issuecommented.vm", "issuereopened.vm", "issuedeleted.vm", "issuemoved.vm", "issueworklogged.vm", "issueworkstarted.vm", "issueworkstopped.vm", "issuegenericevent.vm", "issuecommentedited.vm", "issueworklogupdated.vm", "issueworklogdeleted.vm", "filtersubscription.vm", "share-saved-search.vm", "share-jql-search.vm", "share-issue.vm");
    private static final List<String> HTML_ONLY_ROOT_TEMPLATES = Arrays.asList("issuearchived.vm", "issuerestored.vm");
    private static final List<String> TEMPLATE_TYPES = Arrays.asList("html", "text", "subject");
    private static final List<String> HTML_ONLY_TEMPLATE_TYPES = Arrays.asList("html", "subject");
    @Inject
    protected Administration administration;

    @Test
    @LoginAs(user="admin")
    @SinceBuildRule.SinceBuild(buildNumber=814000)
    public void shouldVerifyThatSingleAndBatchEmailTemplatesWereCopiedFromResourcesToSharedJiraHome() {
        String jiraHomePath = this.administration.getJiraHomeDirectory();
        String singleTemplatesPath = "data" + File.separator + "templates/email/";
        String batchTemplatesPath = "data" + File.separator + "templates/email-batch/";
        this.validateTemplateExistence(jiraHomePath, singleTemplatesPath, ROOT_TEMPLATES, TEMPLATE_TYPES);
        this.validateTemplateExistence(jiraHomePath, singleTemplatesPath, HTML_ONLY_ROOT_TEMPLATES, HTML_ONLY_TEMPLATE_TYPES);
        this.validateTemplateExistence(jiraHomePath, batchTemplatesPath, Arrays.asList("IssueUpdateBatcher.vm", "IssueUpdateBatcher-subject.vm"), Arrays.asList("html", "text"));
        this.validateTemplateExistence(jiraHomePath, batchTemplatesPath, Collections.singletonList("IssueUpdateBatcher.css"), Collections.singletonList("html"));
    }

    private void validateTemplateExistence(String jiraHomePath, String constantPathPart, List<String> rootTemplates, List<String> templateTypes) {
        for (String templateFileName : rootTemplates) {
            for (String templateType : templateTypes) {
                File file = new File(jiraHomePath, constantPathPart + templateType + File.separator + templateFileName);
                Assert.assertTrue((String)("Missing template: " + file.getAbsolutePath()), (boolean)file.exists());
            }
        }
    }
}

