/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.plugins.ReferencePlugin;
import com.atlassian.jira.functest.framework.admin.user.DeleteUserPage;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestDeleteUserSharedEntities
extends BaseJiraFuncTest {
    private static final SharedEntityInfo SYSTEM_PAGE = new SharedEntityInfo(10000L, "System Dashboard", null, true, TestSharingPermissionUtils.createPublicPermissions());
    private static final SharedEntityInfo DASHBOARD_2 = new SharedEntityInfo(10011L, "Dashboard 2", null, true, TestSharingPermissionUtils.createPublicPermissions());
    private static final SharedEntityInfo DASHBOARD_FOR_ADMIN = new SharedEntityInfo(10010L, "Dashboard for Administrator", "Copy of 'System Dashboard'", true, TestSharingPermissionUtils.createPublicPermissions());
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestDeleteUserForSharedEntity.xml");
    }

    @Test
    public void testDeleteUser() {
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("fred"));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromWarningFieldNamed(DeleteUserPage.SHARED_FILTERS), (Matcher)Matchers.equalTo((Object)"3"));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromWarningFieldNamedNoLink(DeleteUserPage.FAVORITED_FILTERS), (Matcher)Matchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromWarningFieldNamed(DeleteUserPage.SHARED_DASHBOARDS), (Matcher)Matchers.equalTo((Object)"3"));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromWarningFieldNamedNoLink(DeleteUserPage.FAVORITED_DASHBOARDS), (Matcher)Matchers.equalTo((Object)"3"));
        deleteUserPage.clickDeleteUser();
        this.navigation.dashboard().navigateToPopular();
        SYSTEM_PAGE.setFavCount(1);
        DASHBOARD_2.setFavCount(1);
        DASHBOARD_FOR_ADMIN.setFavCount(1);
        this.assertions.getDashboardAssertions().assertDashboardPages(Arrays.asList(DASHBOARD_2, DASHBOARD_FOR_ADMIN, SYSTEM_PAGE), Dashboard.Table.POPULAR);
        this.navigation.manageFilters().popularFilters();
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "There are no filters in the system that you can view.");
    }

    @Test
    public void testPreDeleteUserErrorMessages() {
        ReferencePlugin referencePlugin = this.administration.plugins().referencePlugin();
        if (referencePlugin.isInstalled() && referencePlugin.isEnabled()) {
            String refUserName = "predeleteuser";
            this.navigation.login("admin");
            this.administration.usersAndGroups().addUser(refUserName);
            DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters(refUserName));
            MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage(refUserName)));
            MatcherAssert.assertThat((Object)deleteUserPage.getNumberForPluginErrorNamed(Pattern.compile("(.*)Entity:(.*)")), (Matcher)Matchers.equalTo((Object)"17"));
            this.navigation.logout();
        }
    }
}

