/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestEditUserDetails
extends BaseJiraFuncTest {
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminCannotSetSysAdminPassword() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.usersAndGroups().gotoViewUser("root");
            this.tester.assertLinkNotPresentWithText("Set Password");
            this.tester.assertTextPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.navigation.gotoPage(this.page.addXsrfToken("/secure/admin/user/SetPassword.jspa?name=root&password=root&confirm=root"));
            this.tester.assertTextPresent("Error");
            this.assertions.getJiraFormAssertions().assertFormErrMsg("Must be a System Administrator to reset a System Administrator's password.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminCannotEditSysAdminDetails() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.usersAndGroups().gotoViewUser("root");
            this.tester.assertLinkNotPresentWithText("Edit Details");
            this.tester.assertTextPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUser.jspa?editName=root&username=root&fullname=rooty&email=root@example.com"));
            this.tester.assertTextPresent("Error");
            this.tester.assertTextPresent("Only System Administrators can edit other System Administrators details.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testSysAdminCanEditSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.login("root");
            this.administration.usersAndGroups().addUser("anothersysadmin");
            this.administration.usersAndGroups().addUserToGroup("anothersysadmin", "jira-sys-admins");
            this.administration.usersAndGroups().gotoViewUser("anothersysadmin");
            this.tester.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.tester.clickLinkWithText("Edit Details");
            this.tester.setFormElement("fullname", "Rooty");
            this.tester.submit("Update");
            this.tester.assertTextPresent("Rooty");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testSysAdminCanSetSysAdminPassword() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.login("root");
            this.administration.usersAndGroups().addUser("anothersysadmin", "something", "Another User", "another@example.com");
            this.administration.usersAndGroups().addUserToGroup("anothersysadmin", "jira-sys-admins");
            this.administration.usersAndGroups().gotoViewUser("anothersysadmin");
            this.tester.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.tester.clickLinkWithText("Set Password");
            this.tester.setFormElement("password", "another");
            this.tester.setFormElement("confirm", "another");
            this.tester.submit("Update");
            this.navigation.login("anothersysadmin", "another");
            this.tester.assertTextNotPresent("Sorry, your username and password are incorrect - please try again.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminCanEditNormalUser() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.usersAndGroups().gotoViewUser("fred");
            this.tester.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.tester.clickLinkWithText("Edit Details");
            this.tester.setFormElement("fullname", "Freddy Kruger");
            this.tester.submit("Update");
            this.tester.assertTextPresent("Freddy Kruger");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminCanSetNormalUsersPassword() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.usersAndGroups().gotoViewUser("fred");
            this.tester.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.tester.clickLinkWithText("Set Password");
            this.tester.setFormElement("password", "another");
            this.tester.setFormElement("confirm", "another");
            this.tester.submit("Update");
            this.navigation.login("fred", "another");
            this.tester.assertTextNotPresent("Sorry, your username and password are incorrect - please try again.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testUserNameWithScriptTags() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            String value = "\"xss user'bad";
            String valueEncoded = "&quot;xss user&#39;bad";
            this.administration.usersAndGroups().addUser("\"xss user'bad", "password", "\"xss user'bad", "email@email.com");
            this.administration.usersAndGroups().gotoViewUser("\"xss user'bad");
            this.tester.clickLinkWithText("Set Password");
            this.tester.setFormElement("password", "another");
            this.tester.setFormElement("confirm", "another");
            this.tester.submit("Update");
            this.tester.assertTextPresent("&quot;xss user&#39;bad");
            this.tester.assertTextNotPresent("\"xss user'bad");
            this.navigation.login("\"xss user'bad", "another");
            this.tester.assertTextNotPresent("Sorry, your username and password are incorrect - please try again.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    public void testFieldsExceed255() {
        try {
            this.administration.restoreBlankInstance();
            this.administration.usersAndGroups().addUserWithoutVerifyingResult(StringUtils.repeat((String)"abcdefgh", (int)32), "password", StringUtils.repeat((String)"ABCDEFGH", (int)32), StringUtils.repeat((String)"x", (int)246) + "@email.com");
            this.tester.assertTextPresent("The username must not exceed 255 characters in length.");
            this.tester.assertTextPresent("The full name must not exceed 255 characters in length.");
            this.tester.assertTextPresent("The email address must not exceed 255 characters in length.");
            this.administration.usersAndGroups().addUserWithoutVerifyingResult(StringUtils.repeat((String)"abcdefgh", (int)32).substring(0, 255), "password", StringUtils.repeat((String)"ABCDEFGH", (int)32).substring(0, 255), (StringUtils.repeat((String)"x", (int)246) + "@email.com").substring(0, 255));
            this.tester.assertTextNotPresent("The username must not exceed 255 characters in length.");
            this.tester.assertTextNotPresent("The full name must not exceed 255 characters in length.");
            this.tester.assertTextNotPresent("The email address must not exceed 255 characters in length.");
            this.navigation.logout();
            this.navigation.login(StringUtils.repeat((String)"abcdefgh", (int)32).substring(0, 255), "password");
            this.tester.assertTextPresent(StringUtils.repeat((String)"ABCDEFGH", (int)32).substring(0, 255));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin", "admin");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAutocompleteIsOff() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.usersAndGroups().gotoViewUser("fred");
            this.tester.clickLinkWithText("Set Password");
            XPathLocator xpathPassword = new XPathLocator(this.tester, "//*[@name=\"password\"]");
            this.textAssertions.assertRegexMatch(xpathPassword.getHTML(), "autocomplete=[ ]*\"off\"[ ]*");
            XPathLocator xpathConfirm = new XPathLocator(this.tester, "//*[@name=\"confirm\"]");
            this.textAssertions.assertRegexMatch(xpathConfirm.getHTML(), "autocomplete=[ ]*\"off\"[ ]*");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }
}

