/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.rest.v2.issue.GroupBean;
import com.atlassian.jira.testkit.client.UsersAndGroupsControl;
import com.atlassian.jira.webtests.ztests.user.GroupClient;
import com.atlassian.jira.webtests.ztests.user.UsersPageBean;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.USERS_AND_GROUPS})
@Restore(value="TestGroupResourceCountUsers.xml")
public class TestGroupResourceCountUsers
extends BaseJiraFuncTest {
    public static final String GROUP_RESOURCE_COUNT_USERS_XML = "TestGroupResourceCountUsers.xml";
    private GroupClient groupClient;
    private static String EXPAND_ALL_USERS = "users";
    private static final String KOALAS = "Koalas";
    private static final String WOMBATS = "Wombats";
    private static final String WALLABIES = "Wallabies";
    private static final String ECHIDNAS = "Echidnas";
    private static final String SEALIFE = "Sealife";
    private static final String LIONS = "Lions";
    private static final String DIAMOND_TOP = "DiamondTop";
    private static final String DIAMOND_LEFT = "DiamondLeft";
    private static final String DIAMOND_RIGHT = "DiamondRight";
    private static final String DIAMOND_BOTTOM = "DiamondBottom";
    private static final String NEST_1 = "nest1";
    private static final String NEST_2 = "nest2";
    private static final String NEST_3 = "nest3";
    private static final String NEST_4 = "nest4";
    private static final String NEST_5 = "nest5";
    private static final String HALL = "Hall";
    private static final String MIRRORS = "Mirrors";
    private static final String GROUND = "ground";
    @Inject
    private EnvironmentUtils environmentUtils;

    @Before
    public void setup() {
        this.groupClient = new GroupClient(this.environmentData);
    }

    @After
    public void tearDown() {
        this.groupClient.close();
    }

    @Test
    public void membersAreAmalgamatedAcrossDirectories() {
        GroupBean groupBean = this.getGroup(KOALAS);
        Assert.assertThat((Object)groupBean.getUsers().getSize(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((String)"Calculated size matches Crowd", (Object)groupBean.getUsers().getItems(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void nestedGroupsAreObservedInUsersCanonicalDirectory() {
        GroupBean groupBean = this.getGroup(SEALIFE);
        Assert.assertThat((Object)groupBean.getUsers().getSize(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((String)"Calculated size matches Crowd", (Object)groupBean.getUsers().getItems(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void inactiveShadowedUsersAreIgnored() {
        GroupBean groupBean = this.getGroup(WOMBATS);
        Assert.assertThat((Object)groupBean.getUsers().getSize(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"Calculated size matches Crowd", (Object)groupBean.getUsers().getItems(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void inactiveDirectoriesAreIgnored() {
        GroupBean groupBean = this.getGroup(LIONS);
        Assert.assertThat((Object)groupBean.getUsers().getSize(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"Calculated size matches Crowd", (Object)groupBean.getUsers().getItems(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void inactiveGroupStillHasMembers() {
        GroupBean groupBean = this.getGroup(WALLABIES);
        Assert.assertThat((Object)groupBean.getUsers().getSize(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"Calculated size matches Crowd", (Object)groupBean.getUsers().getItems(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void groupsOnlyInLowerPriorityDirectoriesAreFound() {
        GroupBean groupBean = this.getGroup(ECHIDNAS);
        Assert.assertThat((Object)groupBean.getUsers().getSize(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"Calculated size matches Crowd", (Object)groupBean.getUsers().getItems(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void groupNameIsCaseInsensitive() {
        GroupBean groupBean = this.getGroup(KOALAS.toUpperCase());
        Assert.assertThat((Object)groupBean.getUsers().getSize(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((String)"Calculated size matches Crowd", (Object)groupBean.getUsers().getItems(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void memberOfMultipleNestedGroupsIsCountedOnce() {
        GroupBean groupBean = this.getGroup(GROUND);
        Assert.assertThat((Object)groupBean.getUsers().getSize(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"Calculated size matches Crowd", (Object)groupBean.getUsers().getItems(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void deeplyNestedGroupsAreCountedCorrectly() {
        GroupBean nest1 = this.getGroup(NEST_1);
        GroupBean nest2 = this.getGroup(NEST_2);
        GroupBean nest3 = this.getGroup(NEST_3);
        GroupBean nest4 = this.getGroup(NEST_4);
        GroupBean nest5 = this.getGroup(NEST_5);
        Assert.assertThat((Object)nest5.getUsers().getSize(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"Size matches crowd, nest5", (Object)nest5.getUsers().getItems(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)nest4.getUsers().getSize(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"Size matches crowd, nest4", (Object)nest4.getUsers().getItems(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)nest3.getUsers().getSize(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((String)"Size matches crowd, nest3", (Object)nest3.getUsers().getItems(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)nest2.getUsers().getSize(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((String)"Size matches crowd, nest2", (Object)nest2.getUsers().getItems(), (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)nest1.getUsers().getSize(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((String)"Size matches crowd, nest1", (Object)nest1.getUsers().getItems(), (Matcher)Matchers.hasSize((int)5));
    }

    @Test
    public void diamonds_memberOfNestedGroupByTwoRoutesIsCountedOnce() {
        GroupBean bottom = this.getGroup(DIAMOND_BOTTOM);
        GroupBean left = this.getGroup(DIAMOND_LEFT);
        GroupBean right = this.getGroup(DIAMOND_RIGHT);
        GroupBean top = this.getGroup(DIAMOND_TOP);
        Assert.assertThat((Object)bottom.getUsers().getSize(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"Size matches crowd, bottom", (Object)bottom.getUsers().getItems(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)left.getUsers().getSize(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"Size matches crowd, left", (Object)left.getUsers().getItems(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)right.getUsers().getSize(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"Size matches crowd, right", (Object)right.getUsers().getItems(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((String)"User 'Yellow' is a only counted once even though it is a member via two routes", (Object)top.getUsers().getSize(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((String)"Size matches crowd, top", (Object)top.getUsers().getItems(), (Matcher)Matchers.hasSize((int)4));
    }

    @Test
    public void cycles_cyclicalGroupMembershipsAreCountedCorrectly() {
        GroupBean hall = this.getGroup(HALL);
        GroupBean mirrors = this.getGroup(MIRRORS);
        Assert.assertThat((Object)mirrors.getUsers().getSize(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"Size matches crowd, mirrors", (Object)mirrors.getUsers().getItems(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)hall.getUsers().getSize(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"Size matches crowd, hall", (Object)hall.getUsers().getItems(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void countUsersIn2001NestedGroups() {
        Assume.assumeThat((String)"Not running on H2 or HSQL as they are too slow for this test", (Object)this.isH2OrHsqlDatabase(), (Matcher)Matchers.is((Object)false));
        UsersAndGroupsControl usersAndGroups = this.backdoor.usersAndGroups();
        String parentGroupName = "lotsOfNestedChildren";
        usersAndGroups.addGroup(parentGroupName);
        usersAndGroups.addGroups("nestedgroup", 2000, parentGroupName, 1);
        GroupBean groupBean = this.getGroup(parentGroupName);
        Assert.assertThat((Object)groupBean.getUsers().getSize(), (Matcher)Matchers.is((Object)2000));
        Assert.assertThat((String)"Size matches crowd for 2001 nested groups", this.getAllUsersInGroup(parentGroupName), (Matcher)Matchers.hasSize((int)2000));
    }

    @SinceBuildRule.SinceBuild(buildNumber=807000)
    @Test
    public void getCountOfJiraUsersMembers() {
        String parentGroupName = "jira-users";
        GroupBean groupBean = this.getGroup(parentGroupName);
        Assert.assertThat((Object)groupBean.getUsers().getSize(), (Matcher)Matchers.is((Object)21));
        Assert.assertThat((String)"jira-users group is correctly shadowed", this.getAllUsersInGroup(parentGroupName), (Matcher)Matchers.hasSize((int)21));
    }

    private GroupBean getGroup(String groupName) {
        return this.groupClient.getGroupBean(groupName, EXPAND_ALL_USERS);
    }

    private Collection<String> getAllUsersInGroup(String parentGroupName) {
        ArrayList<String> users = new ArrayList<String>();
        UsersPageBean page = this.groupClient.getPaginatedUsersForGroup(parentGroupName, false, 0L, 50L);
        page.getValues().forEach(user -> users.add(user.name));
        while (!page.getIsLast().booleanValue()) {
            page = this.groupClient.getNextPage(page);
            page.getValues().forEach(user -> users.add(user.name));
        }
        return users;
    }

    private boolean isH2OrHsqlDatabase() {
        this.navigation.login("admin", "admin");
        return this.environmentUtils.isH2() || this.environmentUtils.isHsql();
    }
}

