/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.user.DeleteUserPage;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import java.net.URL;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestUserManagement
extends BaseJiraFuncTest {
    private static final String JIRA_DEVELOPERS_GROUP_NAME = "jira-developers";
    private static final String JIRA_ADMINISTRATORS_GROUP_NAME = "jira-administrators";
    private static final String DUPLICATE_GROUP_NAME = "duplicate_group";
    private static final String AUTHENTICATION_ERROR_MSG = "Sorry, your username and password are incorrect - please try again.";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("jira.onboarding.feature.disabled");
    }

    @Test
    @RestoreBlankInstance
    public void testUserManagement() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        if (this.tester.getDialog().isLinkPresentWithText("bob")) {
            this.backdoor.usersAndGroups().deleteUser("bob");
        }
        this.createUser();
        this.createValidGroup();
        this.createInvalidUsers();
        this.createInvalidGroups();
        this.addUserToGroup();
        this.loginWithNewUser();
        this.removeUserFromGroup();
        this.setUserPassword();
        this.deleteUser();
        this.loginWithInvalidUser();
    }

    public void createInvalidUsers() {
        this.logger.log((Object)"Testing User Creation Validation");
        this.addUser("", "bob", "No Username", "bob@stuff.com.com");
        this.tester.assertTextPresent("You must specify a username.");
        this.addUser("bob", "bob", "duplicate_user", "bob@stuff.com.com");
        this.addUser("bob", "bob", "duplicate_user", "bob@stuff.com.com");
        this.tester.assertTextPresent("A user with that username already exists.");
        this.addUser("bob", "bob", "Bob The Builder", "");
        this.tester.assertTextPresent("You must specify an email address.");
        this.addUser("bob", "bob", "Bob The Builder", "asf.com");
        this.tester.assertTextPresent("You must specify a valid email address.");
    }

    public void addUser(String username, String password, String fullname, String emailAddress) {
        this.logger.log((Object)("Creating User " + username));
        this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", password);
        this.tester.setFormElement("fullname", fullname);
        this.tester.setFormElement("email", emailAddress);
        this.tester.submit("Create");
    }

    public void createInvalidGroups() {
        this.logger.log((Object)"Testing Group Creation Validation");
        this.backdoor.usersAndGroups().addGroup(DUPLICATE_GROUP_NAME);
        this.addGroup(DUPLICATE_GROUP_NAME);
        this.tester.assertTextPresent("A group or user with this name already exists.");
        this.backdoor.usersAndGroups().deleteGroup(DUPLICATE_GROUP_NAME);
    }

    private void addGroup(String groupName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", groupName);
        this.tester.submit();
    }

    public void createUser() {
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.tester.assertTextPresent("User: Bob The Builder");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Username:", "bob");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Email", "bob@stuff.com.com");
    }

    public void createValidGroup() {
        this.administration.usersAndGroups().addGroup("Valid Group");
        this.administration.usersAndGroups().deleteGroup("Valid Group");
    }

    public void addUserToGroup() {
        this.administration.usersAndGroups().addUserToGroup("bob", JIRA_DEVELOPERS_GROUP_NAME);
        this.administration.usersAndGroups().addUserToGroup("bob", JIRA_ADMINISTRATORS_GROUP_NAME);
    }

    public void loginWithNewUser() {
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        URL url = this.tester.getDialog().getResponse().getURL();
        Assert.assertEquals((String)"Invalid context", (Object)(this.getEnvironmentData().getContext() + "/"), (Object)url.getPath());
        this.navigation.logout();
        this.navigation.login("admin", "admin");
    }

    public void removeUserFromGroup() {
        this.administration.usersAndGroups().removeUserFromGroup("bob", JIRA_ADMINISTRATORS_GROUP_NAME);
    }

    public void setUserPassword() {
        String NEW_PASSWORD = "new";
        String DIFFERENT_PASSWORD = "diff";
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("bob");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "User:", "Bob The Builder");
        this.tester.clickLinkWithText("Set Password");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Set Password:", "Bob The Builder");
        this.tester.setFormElement("password", "");
        this.tester.setFormElement("confirm", "");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Enter a valid password");
        this.tester.setFormElement("password", "");
        this.tester.setFormElement("confirm", "new");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Enter a valid password");
        this.tester.setFormElement("password", "new");
        this.tester.setFormElement("confirm", "");
        this.tester.submit("Update");
        this.tester.assertTextPresent("The two passwords entered do not match.");
        this.tester.setFormElement("password", "new");
        this.tester.setFormElement("confirm", "diff");
        this.tester.submit("Update");
        this.tester.assertTextPresent("The two passwords entered do not match.");
        this.tester.setFormElement("password", "new");
        this.tester.setFormElement("confirm", "new");
        this.tester.submit("Update");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Password for user bob has successfully been set", "Bob The Builder");
        this.navigation.logout();
        this.navigation.loginAttempt("bob", "bob");
        this.tester.assertTextPresent(AUTHENTICATION_ERROR_MSG);
        this.navigation.login("bob", "new");
        Assert.assertEquals((Object)"Bob The Builder", (Object)this.navigation.userProfile().userName());
        this.navigation.login("admin", "admin");
    }

    @Test
    @Restore(value="TestUserManagement.xml")
    public void testDeleteUserProjectLead() {
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("detkin"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("detkin")));
        this.textAssertions.assertTextPresent(deleteUserPage.getProjectLink(), "Another Project");
        this.textAssertions.assertTextPresent(deleteUserPage.getProjectLink(), "Project 3");
    }

    @Test
    @Restore(value="TestUserManagementComponentLead.xml")
    public void testDeleteUserComponentLead() {
        this.navigateToUser("detkin");
        this.tester.clickLink("deleteuser_link");
        int NUMBER_OF_COMPONENTS = 6;
        int count = 0;
        for (int i = 1; i <= 6; ++i) {
            try {
                this.tester.assertLinkPresentWithText("comp " + i);
                ++count;
                continue;
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
        Assert.assertTrue((count == 6 ? 1 : 0) != 0);
        this.tester.assertSubmitButtonPresent("Delete");
    }

    private void deleteUser() {
        this.logger.log((Object)"Deleting User bob");
        this.navigateToUser("bob");
        this.tester.clickLink("deleteuser_link");
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent("bob");
        this.tester.assertTextPresent("UserBrowser");
        this.tester.assertTextPresent("Displaying users");
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
    }

    private void navigateToUser(String username) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink(username);
    }

    private void loginWithInvalidUser() {
        this.navigation.logout();
        this.navigation.loginAttempt("bob", null);
        this.tester.assertTextPresent(AUTHENTICATION_ERROR_MSG);
    }
}

