/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestUserNameIsEncoded
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testUserNamesAreHtmlEncoded() throws SAXException {
        String brokenUsername = "&quot;my &lt;input&gt; name";
        this.administration.restoreData("TestUsernameIsEncoded.xml");
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        this.backdoor.darkFeatures().enableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
        this.navigation.issue().gotoIssue("HSP-1");
        this.textAssertions.assertTextPresent(this.locator.page(), "Is my broken-name really bad?");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Assignee:", "&quot;my &lt;input&gt; name");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Reporter:", "&quot;my &lt;input&gt; name");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "field1:", "&quot;my &lt;input&gt; name");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "field2:", "&quot;my &lt;input&gt; name");
        this.tester.clickLink("edit-issue");
        this.textAssertions.assertTextPresent(this.locator.page(), "Edit Issue");
        this.tester.selectOption("assignee", "\"my <input> name");
        this.tester.assertFormElementEquals("reporter", "broken");
        this.tester.assertFormElementEquals("customfield_10000", "broken");
        this.tester.assertFormElementEquals("customfield_10001", "admin, broken");
    }
}

