/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.xml.sax.SAXException;

@RestoreBlankInstance
@WebTest(value={Category.FUNC_TEST, Category.REST, Category.USERS_AND_GROUPS})
public class TestUserPickerResource
extends BaseJiraFuncTest {
    private static final String LOGGED_IN_USERNAME_ADMIN = "admin";
    private static final String GROUP_JIRA_DEVELOPERS = "jira-developers";
    private static final String USER_PREFIX = "_test_user_";
    private static final String USERNAME_FORMAT = "_test_user_%d";
    public static final String TEST_ISSUE_SUMMARY = "_test_issue_";
    public static final String USERS = "users";
    @Inject
    FuncTestRestClient client;

    @Test
    public void shouldAssigneeFallbackToDefaultMaxResultsOf50() throws IOException, JSONException, SAXException {
        int defaultMaxResults = 50;
        this.navigation.login(LOGGED_IN_USERNAME_ADMIN);
        this.backdoor.issues().createIssue("HSP", TEST_ISSUE_SUMMARY);
        this.createUsersInGroup(51, GROUP_JIRA_DEVELOPERS);
        WebResponse webResponse = this.client.GET("/rest/internal/2/users/assignee?projectKeys=HSP");
        Assertions.assertThat((int)webResponse.getResponseCode()).isEqualTo(HttpStatus.OK.code);
        JSONObject jsonObject = new JSONObject(webResponse.getText());
        Assertions.assertThat((Object)jsonObject).isNotNull();
        JSONArray usersJsonArray = jsonObject.getJSONArray(USERS);
        Assertions.assertThat((int)usersJsonArray.length()).isEqualTo(50);
    }

    @Test
    public void shouldAssigneeFallbackToDefaultQueryOfEmptyString() throws IOException, JSONException, SAXException {
        int createdUserCount = 3;
        int userCountWithAdmin = 4;
        this.navigation.login(LOGGED_IN_USERNAME_ADMIN);
        this.backdoor.issues().createIssue("HSP", TEST_ISSUE_SUMMARY);
        this.createUsersInGroup(3, GROUP_JIRA_DEVELOPERS);
        WebResponse webResponse = this.client.GET("/rest/internal/2/users/assignee?projectKeys=HSP&maxResults=10");
        Assertions.assertThat((int)webResponse.getResponseCode()).isEqualTo(HttpStatus.OK.code);
        JSONObject jsonObject = new JSONObject(webResponse.getText());
        Assertions.assertThat((Object)jsonObject).isNotNull();
        JSONArray usersJsonArray = jsonObject.getJSONArray(USERS);
        Assertions.assertThat((int)usersJsonArray.length()).isEqualTo(4);
    }

    @Test
    public void shouldAssigneeFallbackToDefaultIncludeInvolvementOfFalse() throws IOException, JSONException, SAXException {
        boolean onlyAdminUserCount = true;
        this.navigation.login(LOGGED_IN_USERNAME_ADMIN);
        this.backdoor.issues().createIssue("HSP", TEST_ISSUE_SUMMARY);
        WebResponse webResponse = this.client.GET("/rest/internal/2/users/assignee?projectKeys=HSP&maxResults=10");
        Assertions.assertThat((int)webResponse.getResponseCode()).isEqualTo(HttpStatus.OK.code);
        JSONObject responseJson = new JSONObject(webResponse.getText());
        Assertions.assertThat((Object)responseJson).isNotNull();
        JSONArray users = responseJson.getJSONArray(USERS);
        Assertions.assertThat((int)users.length()).isEqualTo(1);
        JSONObject user = users.getJSONObject(0);
        boolean hasIssueInvolvements = user.has("issueInvolvements");
        Assertions.assertThat((boolean)hasIssueInvolvements).isFalse();
    }

    @Test
    public void shouldAssigneeSucceedWithIssueKey() throws IOException, JSONException, SAXException {
        boolean onlyAdminUserCount = true;
        this.navigation.login(LOGGED_IN_USERNAME_ADMIN);
        IssueCreateResponse issueCreateResponse = this.backdoor.issues().createIssue("HSP", TEST_ISSUE_SUMMARY);
        WebResponse webResponse = this.client.GET(String.format("/rest/internal/2/users/assignee?issueKey=%s", issueCreateResponse.key));
        Assertions.assertThat((int)webResponse.getResponseCode()).isEqualTo(HttpStatus.OK.code);
        JSONObject responseJson = new JSONObject(webResponse.getText());
        Assertions.assertThat((Object)responseJson).isNotNull();
        JSONArray users = responseJson.getJSONArray(USERS);
        Assertions.assertThat((int)users.length()).isEqualTo(1);
    }

    @Test
    public void shouldAssigneeFailWithoutIssueKeyAndProjectKeys() throws IOException, JSONException, SAXException {
        this.navigation.login(LOGGED_IN_USERNAME_ADMIN);
        WebResponse webResponse = this.client.GET("/rest/internal/2/users/assignee");
        Assertions.assertThat((int)webResponse.getResponseCode()).isEqualTo(HttpStatus.BAD_REQUEST.code);
        JSONObject responseJson = new JSONObject(webResponse.getText());
        Assertions.assertThat((Object)responseJson).isNotNull();
    }

    void createUsersInGroup(int userCount, String group) {
        IntStream.range(0, userCount).forEach(index -> {
            String username = String.format(USERNAME_FORMAT, index);
            this.backdoor.usersAndGroups().addUser(username).addUserToGroup(username, group);
        });
        this.backdoor.cacheControl().flushCaches();
    }
}

