/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.WebTesterFactory;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestUserRememberMeCookies
extends BaseJiraFuncTest {
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        for (int i = 0; i < 5; ++i) {
            this.loginAs("admin");
        }
    }

    @Test
    public void testHasRememberMeCookies() {
        this.gotoRememberMeUserBrowserAdminSection();
        this.textAssertions.assertTextSequence(this.locator.xpath("//form[@id='rememberme_cookies_form']//h2"), "Remember My Login", "Administrator");
        Assert.assertEquals((String)"There should be 5 rows of cookies", (long)5L, (long)this.locator.xpath("//table[@id='rememberme_cookies_table']//tbody/tr").getNodes().length);
        this.tester.submit("Submit");
        this.assertHasNoRememberMeCookies();
    }

    @Test
    public void testUserProfileRememberMeClear() {
        this.navigation.gotoPage("secure/ViewProfile.jspa");
        this.tester.clickLink("view_clear_rememberme");
        this.textAssertions.assertTextPresent("Remember My Login");
        this.tester.submit("Clear");
        this.textAssertions.assertTextPresent("Your remember my login tokens have successfully been cleared");
        this.gotoRememberMeUserBrowserAdminSection();
        this.assertHasNoRememberMeCookies();
    }

    @Test
    public void testUserProfileRememberMeClear_NotLoggedIn() {
        this.navigation.logout();
        this.navigation.gotoPage("secure/ClearRememberMeCookies!default.jspa");
        this.textAssertions.assertTextPresent("You must be logged in to clear your remember my login tokens.");
    }

    @Test
    public void testAllUsersRememberMeClear() {
        this.navigation.gotoPage("secure/admin/user/AllUsersRememberMeCookies!default.jspa");
        this.assertWeAreOnTheClearAllPage(5);
        this.navigation.gotoAdminSection(Navigation.AdminSection.REMEMBERME);
        this.assertWeAreOnTheClearAllPage(5);
        this.tester.submit("Submit");
        this.textAssertions.assertTextPresent("All the tokens have been cleared.");
        this.assertWeAreOnTheClearAllPage(0);
        this.gotoRememberMeUserBrowserAdminSection();
        this.assertHasNoRememberMeCookies();
    }

    private void assertWeAreOnTheClearAllPage(Integer numberOfTokens) {
        this.textAssertions.assertTextPresent("Remember My Login for All Users");
        this.textAssertions.assertTextPresent("to clear all of these tokens from this Jira site.");
        this.textAssertions.assertTextPresent(this.locator.xpath("//div[@class='form-body']/p/strong"), numberOfTokens.toString());
    }

    private void assertHasNoRememberMeCookies() {
        this.textAssertions.assertTextPresent(this.locator.xpath("//form[@id='rememberme_cookies_form']"), "No login tokens have been set for: Administrator");
    }

    private void gotoRememberMeUserBrowserAdminSection() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("admin");
        this.tester.clickLink("rememberme_link");
    }

    private void loginAs(String userName) {
        WebTester tester = WebTesterFactory.createNewWebTester(this.environmentData);
        tester.beginAt("/login.jsp");
        tester.setFormElement("os_username", userName);
        tester.setFormElement("os_password", userName);
        tester.setFormElement("os_cookie", "true");
        tester.setWorkingForm("login-form");
        tester.submit();
        this.logger.log((Object)("Started session for " + userName));
    }
}

