/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.google.common.collect.ImmutableMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.ANONYMIZE_USER})
@Restore(value="anonymizationForeignKeys.xml")
public class TestAnonymizeDisplayNameInIssueHistory
extends BaseJiraFuncTest {
    private static final long SINGLE_PICKER = 10000L;
    private static final long MULTI_PICKER = 10100L;
    private static final FeatureFlag DB_ID_BASED_KEY_GENERATION_STRATEGY = FeatureFlag.featureFlag((String)"com.atlassian.jira.user.dbIdBasedKeyGenerationStrategy");
    private UserAnonymizeControl userAnonymizeControl;
    private Issue issue;
    private UserDTO john;

    @Before
    public void setUp() {
        this.userAnonymizeControl = new UserAnonymizeControl(this.environmentData);
        this.backdoor.darkFeatures().enableForSite(DB_ID_BASED_KEY_GENERATION_STRATEGY);
        this.backdoor.usersAndGroups().addUser("john", "secret", "John Doe", "john@example.com");
        this.backdoor.usersAndGroups().addUserToGroup("john", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.issue = this.backdoor.issues().getIssue("ANON-3");
        this.john = this.backdoor.usersAndGroups().getUserByName("john");
    }

    @Test
    public void testAnonymizeSystemField() {
        this.backdoor.issues().assignIssue(this.issue.key, "john");
        UserAnonymizeControl.AnonymizePerformResult result = this.userAnonymizeControl.anonymize(this.john.getKey(), false, null, null, "admin");
        Assert.assertNull((String)"User key hasn't been changed", (Object)result.getUserKeyNew());
        Issue issueAfter = this.backdoor.issues().getIssue(this.issue.key, new Issue.Expand[]{Issue.Expand.changelog});
        Assert.assertThat((Object)issueAfter.changelog.mergeHistoryItems(), (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)this.john.getKey()))));
    }

    @Test
    public void testAnonymizeSingleValueCustomField() {
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateSingleUserField(10000L, "john"));
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateSingleUserField(10000L, "admin"));
        UserAnonymizeControl.AnonymizePerformResult result = this.userAnonymizeControl.anonymize(this.john.getKey(), false, null, null, "admin");
        Assert.assertNull((String)"User key hasn't been changed", (Object)result.getUserKeyNew());
        Issue issueAfter = this.backdoor.issues().getIssue(this.issue.key, new Issue.Expand[]{Issue.Expand.changelog});
        Assert.assertThat((Object)issueAfter.changelog.mergeHistoryItems(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)this.john.getKey())), Matchers.hasProperty((String)"fromString", (Matcher)Matchers.equalTo((Object)this.john.getKey()))}));
    }

    @Test
    public void testAnonymizeMultiValueCustomField() {
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateMultiUserField(10100L, "john", "admin"));
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateMultiUserField(10100L, "john"));
        UserAnonymizeControl.AnonymizePerformResult result = this.userAnonymizeControl.anonymize(this.john.getKey(), false, null, null, "admin");
        Assert.assertNull((String)"User key hasn't been changed", (Object)result.getUserKeyNew());
        String adminAndJohn = "Administrator, " + this.john.getKey();
        Issue issueAfter = this.backdoor.issues().getIssue(this.issue.key, new Issue.Expand[]{Issue.Expand.changelog});
        Assert.assertThat((Object)issueAfter.changelog.mergeHistoryItems(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)adminAndJohn)), Matchers.allOf((Matcher)Matchers.hasProperty((String)"fromString", (Matcher)Matchers.equalTo((Object)adminAndJohn)), (Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)this.john.getKey())))}));
    }

    @Test
    public void testAnonymizeDeletedUser() {
        this.backdoor.issues().assignIssue(this.issue.key, "john");
        this.backdoor.issues().assignIssue(this.issue.key, "admin");
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateSingleUserField(10000L, "john"));
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateMultiUserField(10100L, "admin", "john"));
        this.backdoor.usersAndGroups().deleteUser("john");
        this.userAnonymizeControl.anonymize(this.john.getKey(), false, null, null, "admin");
        Issue issueAfter = this.backdoor.issues().getIssue(this.issue.key, new Issue.Expand[]{Issue.Expand.changelog});
        String adminAndJohn = "Administrator, " + this.john.getKey();
        Assert.assertThat((Object)issueAfter.changelog.mergeHistoryItems(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)"assignee")), (Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)this.john.getKey()))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)"assignee")), (Matcher)Matchers.hasProperty((String)"fromString", (Matcher)Matchers.equalTo((Object)this.john.getKey()))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)"multi-user")), (Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)adminAndJohn)))}));
    }

    @Test
    public void exportData() {
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateMultiUserField(10100L, "fred", "admin"));
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateMultiUserField(10100L, "fred"));
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateSingleUserField(10000L, "fred"));
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateSingleUserField(10000L, "admin"));
        this.backdoor.issues().assignIssue(this.issue.key, "fred");
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateMultiUserField(10100L, "john", "admin"));
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateMultiUserField(10100L, "john"));
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateSingleUserField(10000L, "john"));
        this.backdoor.issues().setIssueFields(this.issue.key, TestAnonymizeDisplayNameInIssueHistory.updateSingleUserField(10000L, "admin"));
        this.backdoor.issues().assignIssue(this.issue.key, "john");
        this.userAnonymizeControl.anonymize("fred", false, null, null, "admin");
        this.userAnonymizeControl.anonymize(this.john.getKey(), false, null, null, "admin");
        this.backdoor.export().export("anonymizationForeignKeys-rerun.xml");
    }

    private static IssueFields updateSingleUserField(long id, String name) {
        return TestAnonymizeDisplayNameInIssueHistory.updateCustomField(id, ImmutableMap.of((Object)"name", (Object)name));
    }

    private static IssueFields updateMultiUserField(long id, String ... names) {
        Object[] values = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            values[i] = ImmutableMap.of((Object)"name", (Object)names[i]);
        }
        return TestAnonymizeDisplayNameInIssueHistory.updateCustomField(id, values);
    }

    private static IssueFields updateCustomField(long id, Object value) {
        IssueFields fields = new IssueFields();
        fields.customField(Long.valueOf(id), value);
        return fields;
    }
}

