/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.restclient.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.ANONYMIZE_USER})
@Restore(value="anonymization-rerun-issue-history.xml")
public class TestAnonymizeDisplayNameInIssueHistoryRerun
extends BaseJiraFuncTest {
    private UserAnonymizeControl userAnonymizeControl;
    private Issue issue;
    private String fredNewKey = "JIRAUSER10000";
    private String fredOldKey = "fred";
    private String johnNewKey = "JIRAUSER10200";
    private String johnOldKey = "JIRAUSER10200";

    @Before
    public void setUp() {
        this.userAnonymizeControl = new UserAnonymizeControl(this.environmentData);
        this.issue = this.backdoor.issues().getIssue("ANON-3");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=812000)
    public void testUserWithOldKey() {
        this.userAnonymizeControl.anonymize(this.fredNewKey, true, this.fredOldKey, "fred", "admin");
        Issue issueAfter = this.backdoor.issues().getIssue(this.issue.key, new Issue.Expand[]{Issue.Expand.changelog});
        String adminAndFred = "Administrator, " + this.fredNewKey;
        Assert.assertThat((Object)issueAfter.changelog.mergeHistoryItems(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)"assignee")), (Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)this.fredNewKey))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)"selected-user")), (Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)this.fredNewKey))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)"multi-user")), (Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)adminAndFred)))}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=812000)
    public void testUserWithNewKey() {
        this.userAnonymizeControl.anonymize(this.johnNewKey, true, this.johnOldKey, "john", "admin");
        Issue issueAfter = this.backdoor.issues().getIssue(this.issue.key, new Issue.Expand[]{Issue.Expand.changelog});
        String adminAndJohn = "Administrator, " + this.johnNewKey;
        Assert.assertThat((Object)issueAfter.changelog.mergeHistoryItems(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)"assignee")), (Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)this.johnNewKey))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)"selected-user")), (Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)this.johnNewKey))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)"multi-user")), (Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)adminAndJohn)))}));
    }
}

