/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.plugins.Plugins;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.MapMatchers;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationProgressBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RestoreBlankInstance
@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.ANONYMIZE_USER, Category.PLUGINS})
public class TestBusinessLogicValidation
extends BaseJiraFuncTest {
    private static final String NAME_HANDLER_KEY = TestBusinessLogicValidation.toCompleteKey("user-name-change-handler-with-bl-validation-errors");
    private static final String KEY_HANDLER_KEY = TestBusinessLogicValidation.toCompleteKey("user-key-change-handler-with-bl-validation-errors");
    private static final String OWNERSHIP_HANDLER_KEY = TestBusinessLogicValidation.toCompleteKey("ownership-transfer-handler-with-bl-validation-errors");
    private static final String ANONYMIZATION_HANDLER_KEY = TestBusinessLogicValidation.toCompleteKey("user-anonymization-handler-with-bl-validation-errors");
    private static final List<String> COMPLETE_MODULE_KEYS = ImmutableList.of((Object)NAME_HANDLER_KEY, (Object)KEY_HANDLER_KEY, (Object)OWNERSHIP_HANDLER_KEY, (Object)ANONYMIZATION_HANDLER_KEY);
    private UserAnonymizeControl userAnonymizeControl;
    @Inject
    private Plugins plugins;

    @Before
    public void setUp() {
        this.userAnonymizeControl = new UserAnonymizeControl(this.environmentData);
    }

    @Test
    @LoginAs(user="admin")
    public void GIVENSomePluginPointsWithFailingBusinessLogicWHENanonymizeTHENreturnsExpectedErrors() {
        this.withBLValidationPluginPointsEnabled(() -> {
            this.userAnonymizeControl.scheduleUserAnonymization("fred", "admin");
            UserAnonymizationProgressBean progressBean = this.userAnonymizeControl.fetchFinishedProgressResult();
            Assert.assertThat((Object)progressBean.getUserKey(), (Matcher)Matchers.equalTo((Object)"fred"));
            Assert.assertThat((Object)progressBean.getUserName(), (Matcher)Matchers.equalTo((Object)"fred"));
            Assert.assertThat((Object)progressBean.getFullName(), (Matcher)Matchers.equalTo((Object)"Fred Normal"));
            Assert.assertThat((Object)progressBean.getProgressUrl(), (Matcher)Matchers.startsWith((String)"/rest/api/2/user/anonymization/progress?taskId="));
            Assert.assertThat((Object)progressBean.getStartTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getSubmittedTime()));
            Assert.assertThat((Object)progressBean.getFinishTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getStartTime()));
            Assert.assertThat((Object)progressBean.getStatus(), (Matcher)Matchers.equalTo((Object)UserAnonymizationProgressBean.AnonymizationStatus.VALIDATION_FAILED));
            Assert.assertThat((Object)progressBean.getCurrentProgress(), (Matcher)Matchers.equalTo((Object)100L));
            Assert.assertThat((Object)progressBean.getCurrentSubTask(), (Matcher)Matchers.nullValue());
            Assert.assertThat((Object)progressBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)progressBean.getErrors(), (Matcher)MapMatchers.isMapWithSize((int)4));
            Assert.assertThat((Object)progressBean.getErrors(), (Matcher)MapMatchers.hasEntries((Map)ImmutableMap.of((Object)NAME_HANDLER_KEY, (Object)ErrorCollection.of((String[])new String[]{"UserNameChangeHandler BL validation failed for user key fred"}), (Object)KEY_HANDLER_KEY, (Object)ErrorCollection.of((String[])new String[]{"UserKeyChangeHandler BL validation failed for user key fred", "some other error"}), (Object)OWNERSHIP_HANDLER_KEY, (Object)ErrorCollection.of((String[])new String[]{"OwnershipTransferHandler BL validation failed for user key fred transfer to admin"}), (Object)ANONYMIZATION_HANDLER_KEY, (Object)ErrorCollection.of((String[])new String[]{"UserAnonymizationHandler BL validation failed for user key fred"}))));
            Assert.assertThat((Object)progressBean.getOperations(), (Matcher)Matchers.empty());
            Assert.assertThat((Object)progressBean.isRerun(), (Matcher)Matchers.equalTo((Object)false));
        });
    }

    private void withBLValidationPluginPointsEnabled(Runnable r) {
        COMPLETE_MODULE_KEYS.forEach(key -> this.plugins.enablePluginModule("com.atlassian.jira.dev.func-test-plugin", (String)key));
        try {
            r.run();
        }
        finally {
            COMPLETE_MODULE_KEYS.forEach(key -> this.plugins.disablePluginModule("com.atlassian.jira.dev.func-test-plugin", (String)key));
        }
    }

    private static String toCompleteKey(String key) {
        return "com.atlassian.jira.dev.func-test-plugin:" + key;
    }
}

